/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.armortrim;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TrimMaterialsPM {
    protected static final Map<ResourceKey<TrimMaterial>, Source> SOURCE_MAPPING = new HashMap<ResourceKey<TrimMaterial>, Source>();
    public static final ResourceKey<TrimMaterial> RUNE_EARTH = TrimMaterialsPM.registryKey("rune_earth", Sources.EARTH);
    public static final ResourceKey<TrimMaterial> RUNE_SEA = TrimMaterialsPM.registryKey("rune_sea", Sources.SEA);
    public static final ResourceKey<TrimMaterial> RUNE_SKY = TrimMaterialsPM.registryKey("rune_sky", Sources.SKY);
    public static final ResourceKey<TrimMaterial> RUNE_SUN = TrimMaterialsPM.registryKey("rune_sun", Sources.SUN);
    public static final ResourceKey<TrimMaterial> RUNE_MOON = TrimMaterialsPM.registryKey("rune_moon", Sources.MOON);
    public static final ResourceKey<TrimMaterial> RUNE_BLOOD = TrimMaterialsPM.registryKey("rune_blood", Sources.BLOOD);
    public static final ResourceKey<TrimMaterial> RUNE_INFERNAL = TrimMaterialsPM.registryKey("rune_infernal", Sources.INFERNAL);
    public static final ResourceKey<TrimMaterial> RUNE_VOID = TrimMaterialsPM.registryKey("rune_void", Sources.VOID);
    public static final ResourceKey<TrimMaterial> RUNE_HALLOWED = TrimMaterialsPM.registryKey("rune_hallowed", Sources.HALLOWED);

    private static ResourceKey<TrimMaterial> registryKey(String name, Source source) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceUtils.loc(name));
        if (SOURCE_MAPPING.containsKey(key)) {
            throw new IllegalStateException("Source mapping already set for trim material " + name);
        }
        SOURCE_MAPPING.put((ResourceKey<TrimMaterial>)key, source);
        return key;
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item item, Style textStyle, float itemModelIndex) {
        context.register(materialKey, (Object)TrimMaterial.create((String)materialKey.location().getPath(), (Item)item, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)materialKey.location())).withStyle(textStyle), Map.of()));
    }

    private static Style getStyle(Source source) {
        return Style.EMPTY.withColor(source.getColor());
    }

    public static Source getSource(ResourceKey<TrimMaterial> key) {
        if (!SOURCE_MAPPING.containsKey(key)) {
            throw new IllegalArgumentException("No source mapping found for trim material " + key.toString());
        }
        return SOURCE_MAPPING.get(key);
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        TrimMaterialsPM.register(context, RUNE_EARTH, ItemsPM.RUNE_EARTH.get(), TrimMaterialsPM.getStyle(Sources.EARTH), 0.7f);
        TrimMaterialsPM.register(context, RUNE_SEA, ItemsPM.RUNE_SEA.get(), TrimMaterialsPM.getStyle(Sources.SEA), 0.9f);
        TrimMaterialsPM.register(context, RUNE_SKY, ItemsPM.RUNE_SKY.get(), TrimMaterialsPM.getStyle(Sources.SKY), 0.8f);
        TrimMaterialsPM.register(context, RUNE_SUN, ItemsPM.RUNE_SUN.get(), TrimMaterialsPM.getStyle(Sources.SUN), 0.6f);
        TrimMaterialsPM.register(context, RUNE_MOON, ItemsPM.RUNE_MOON.get(), TrimMaterialsPM.getStyle(Sources.MOON), 0.2f);
        TrimMaterialsPM.register(context, RUNE_BLOOD, ItemsPM.RUNE_BLOOD.get(), TrimMaterialsPM.getStyle(Sources.BLOOD), 0.4f);
        TrimMaterialsPM.register(context, RUNE_INFERNAL, ItemsPM.RUNE_INFERNAL.get(), TrimMaterialsPM.getStyle(Sources.INFERNAL), 0.5f);
        TrimMaterialsPM.register(context, RUNE_VOID, ItemsPM.RUNE_VOID.get(), TrimMaterialsPM.getStyle(Sources.VOID), 1.0f);
        TrimMaterialsPM.register(context, RUNE_HALLOWED, ItemsPM.RUNE_HALLOWED.get(), TrimMaterialsPM.getStyle(Sources.HALLOWED), 0.1f);
    }
}

