/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class StatValueTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.codec();
    }

    public void trigger(ServerPlayer player, Stat stat, int value) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(stat, value));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Stat stat, int threshold) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Codec<TriggerInstance> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceLocation.CODEC.fieldOf("stat").xmap(loc -> StatsManager.getStat(loc), stat -> stat.key()).forGetter(TriggerInstance::stat), (App)Codec.INT.fieldOf("threshold").forGetter(TriggerInstance::threshold)).apply((Applicative)instance, TriggerInstance::new));
        }

        public static Criterion<TriggerInstance> atLeast(Stat stat, int threshold) {
            return CriteriaTriggersPM.STAT_VALUE.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), stat, threshold));
        }

        public boolean matches(Stat stat, int value) {
            return this.stat.equals(stat) && value >= this.threshold;
        }
    }
}

