/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;

public class ScanLocationTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer pPlayer, BlockPos pPos, ItemStack pStack) {
        ServerLevel serverLevel = pPlayer.serverLevel();
        BlockState blockState = serverLevel.getBlockState(pPos);
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)pPos.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)pPlayer).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState).withParameter(LootContextParams.TOOL, (Object)pStack).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        this.trigger(pPlayer, triggerInstance -> triggerInstance.matches(lootContext));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        private static TriggerInstance itemUsedOnLocation(LocationPredicate.Builder pLocation, ItemPredicate.Builder pTool) {
            ContextAwarePredicate predicate = ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LocationCheck.checkLocation((LocationPredicate.Builder)pLocation).build(), MatchTool.toolMatches((ItemPredicate.Builder)pTool).build()});
            return new TriggerInstance(Optional.empty(), Optional.of(predicate));
        }

        public static Criterion<TriggerInstance> itemUsedOnBlock(LocationPredicate.Builder pLocation, ItemPredicate.Builder pTool) {
            return CriteriaTriggersPM.SCAN_LOCATION.get().createCriterion((CriterionTriggerInstance)TriggerInstance.itemUsedOnLocation(pLocation, pTool));
        }

        public boolean matches(LootContext pContext) {
            return this.location.isEmpty() || this.location.get().matches(pContext);
        }

        public void validate(CriterionValidator pValidator) {
            super.validate(pValidator);
            this.location.ifPresent(loc -> pValidator.validate(loc, LootContextParamSets.ADVANCEMENT_LOCATION, ".location"));
        }
    }
}

