/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.enchantment.Enchantment;

public class RunescribingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.codec();
    }

    public void trigger(ServerPlayer player, Holder<Enchantment> ench) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(ench));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Holder<Enchantment>> enchantmentIdOpt) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Codec<TriggerInstance> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Enchantment.CODEC.optionalFieldOf("enchantment").forGetter(TriggerInstance::enchantmentIdOpt)).apply((Applicative)instance, TriggerInstance::new));
        }

        public static Criterion<TriggerInstance> enchantment(Holder<Enchantment> ench) {
            return CriteriaTriggersPM.RUNESCRIBING.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(ench)));
        }

        public boolean matches(Holder<Enchantment> other) {
            return this.enchantmentIdOpt.isPresent() && this.enchantmentIdOpt.get().equals(other);
        }
    }
}

