/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.runes.Rune;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class RuneUseCountTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Rune rune, int value) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(rune, value));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Rune> runeOpt, int threshold) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Rune.CODEC.optionalFieldOf("rune").forGetter(TriggerInstance::runeOpt), (App)Codec.INT.fieldOf("threshold").forGetter(TriggerInstance::threshold)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> atLeast(int threshold) {
            return CriteriaTriggersPM.RUNE_USE_COUNT.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), threshold));
        }

        public static Criterion<TriggerInstance> atLeast(Rune rune, int threshold) {
            return CriteriaTriggersPM.RUNE_USE_COUNT.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(rune), threshold));
        }

        public boolean matches(Rune rune, int value) {
            if (this.runeOpt.isPresent() && !this.runeOpt.get().getId().equals((Object)rune.getId())) {
                return false;
            }
            return value >= this.threshold;
        }
    }
}

