/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.EntityScanKey;
import com.verdantartifice.primalmagick.common.research.keys.ItemScanKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.research.keys.StackCraftedKey;
import com.verdantartifice.primalmagick.common.research.keys.TagCraftedKey;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class ResearchCompletedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.codec();
    }

    public void trigger(ServerPlayer player, AbstractResearchKey<?> completedKey) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(completedKey));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, AbstractResearchKey<?> researchKey) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Codec<TriggerInstance> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)AbstractResearchKey.dispatchCodec().fieldOf("researchKey").forGetter(TriggerInstance::researchKey)).apply((Applicative)instance, TriggerInstance::new));
        }

        public static Criterion<TriggerInstance> entityScanned(EntityType<?> entityType) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new EntityScanKey(entityType)));
        }

        public static Criterion<TriggerInstance> itemScanned(ItemLike itemLike) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new ItemScanKey(itemLike)));
        }

        public static Criterion<TriggerInstance> itemScanned(ItemStack stack) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new ItemScanKey(stack)));
        }

        public static Criterion<TriggerInstance> researchEntry(ResourceKey<ResearchEntry> rawKey) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new ResearchEntryKey(rawKey)));
        }

        public static Criterion<TriggerInstance> runescribed(Holder<Enchantment> ench) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new RuneEnchantmentKey(ench)));
        }

        public static Criterion<TriggerInstance> stackCrafted(ItemLike itemLike) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new StackCraftedKey(itemLike)));
        }

        public static Criterion<TriggerInstance> stackCrafted(ItemStack stack) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new StackCraftedKey(stack)));
        }

        public static Criterion<TriggerInstance> tagCrafted(TagKey<Item> tagKey) {
            return CriteriaTriggersPM.RESEARCH_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), new TagCraftedKey(tagKey)));
        }

        public boolean matches(AbstractResearchKey<?> completedKey) {
            return this.researchKey.equals(completedKey);
        }
    }
}

