/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class ManaNetworkRouteLengthTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, double dist) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(dist));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, double threshold) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(TriggerInstance::threshold)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> atLeast(int threshold) {
            return CriteriaTriggersPM.MANA_NETWORK_ROUTE_LENGTH.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), threshold));
        }

        public boolean matches(double value) {
            return value >= this.threshold;
        }
    }
}

