/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;

public class LinguisticsComprehensionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.codec();
    }

    public void trigger(ServerPlayer player, ResourceKey<BookLanguage> language, int value) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(language, value));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, ResourceKey<BookLanguage> language, int threshold) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Codec<TriggerInstance> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceKey.codec(RegistryKeysPM.BOOK_LANGUAGES).fieldOf("language").forGetter(TriggerInstance::language), (App)Codec.INT.fieldOf("threshold").forGetter(TriggerInstance::threshold)).apply((Applicative)instance, TriggerInstance::new));
        }

        public static Criterion<TriggerInstance> atLeast(ResourceKey<BookLanguage> language, int threshold) {
            return CriteriaTriggersPM.LINGUISTICS_COMPREHENSION.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), language, threshold));
        }

        public boolean matches(ResourceKey<BookLanguage> language, int value) {
            return this.language.equals(language) && value >= this.threshold;
        }
    }
}

