/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class EntityHurtPlayerTriggerExt
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer pPlayer, DamageSource pSource, float pAmountDealt) {
        LootContext playerContext = EntityPredicate.createContext((ServerPlayer)pPlayer, (Entity)pPlayer);
        this.trigger(pPlayer, triggerInstance -> triggerInstance.matches(pPlayer, playerContext, pSource, pAmountDealt, pAmountDealt, false));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<DamagePredicate> damage) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)DamagePredicate.CODEC.optionalFieldOf("damage").forGetter(TriggerInstance::damage)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> playerHurtEntity(Optional<EntityPredicate> pPlayer, Optional<DamagePredicate> pDamage) {
            return CriteriaTriggersPM.ENTITY_HURT_PLAYER_EXT.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(EntityPredicate.wrap(pPlayer), pDamage));
        }

        public static Criterion<TriggerInstance> playerHurtEntity(Optional<EntityPredicate> pPlayer, DamagePredicate.Builder pDamage) {
            return CriteriaTriggersPM.ENTITY_HURT_PLAYER_EXT.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(EntityPredicate.wrap(pPlayer), Optional.of(pDamage.build())));
        }

        public boolean matches(ServerPlayer pPlayer, LootContext pPlayerContext, DamageSource pDamage, float pDealt, float pTaken, boolean pBlocked) {
            if (this.damage.isPresent() && !this.damage.get().matches(pPlayer, pDamage, pDealt, pTaken, pBlocked)) {
                return false;
            }
            return !this.player.isPresent() || this.player.get().matches(pPlayerContext);
        }
    }
}

