/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class AttunementThresholdTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Source source, int p, int i, int t) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(source, p, i, t));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Source> source, Optional<AttunementThreshold> lasting, Optional<AttunementThreshold> ephemeral) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Source.CODEC.optionalFieldOf("source").forGetter(TriggerInstance::source), (App)AttunementThreshold.CODEC.optionalFieldOf("lasting").forGetter(TriggerInstance::lasting), (App)AttunementThreshold.CODEC.optionalFieldOf("ephemeral").forGetter(TriggerInstance::ephemeral)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> anyLasting(AttunementThreshold threshold) {
            return CriteriaTriggersPM.ATTUNEMENT_THRESHOLD.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(threshold), Optional.empty()));
        }

        public static Criterion<TriggerInstance> anyEphemeral(AttunementThreshold threshold) {
            return CriteriaTriggersPM.ATTUNEMENT_THRESHOLD.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(threshold)));
        }

        public static Criterion<TriggerInstance> lasting(Source source, AttunementThreshold threshold) {
            return CriteriaTriggersPM.ATTUNEMENT_THRESHOLD.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(source), Optional.of(threshold), Optional.empty()));
        }

        public static Criterion<TriggerInstance> ephemeral(Source source, AttunementThreshold threshold) {
            return CriteriaTriggersPM.ATTUNEMENT_THRESHOLD.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(source), Optional.empty(), Optional.of(threshold)));
        }

        public boolean matches(Source source, int permanent, int induced, int temporary) {
            if (this.source.isPresent() && !this.source.get().equals(source)) {
                return false;
            }
            if (this.lasting.isPresent()) {
                return permanent + induced >= this.lasting.get().getValue();
            }
            if (this.ephemeral.isPresent()) {
                return permanent + induced + temporary >= this.ephemeral.get().getValue();
            }
            return true;
        }
    }
}

