/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static boolean renderItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text, boolean hideStackOverlay) {
        boolean retVal = false;
        if (stack != null && !stack.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 32.0f);
            guiGraphics.renderItem(stack, x, y);
            if (!hideStackOverlay) {
                guiGraphics.renderItemDecorations(mc.font, stack, x, y, text);
            }
            guiGraphics.pose().popPose();
            retVal = true;
        }
        return retVal;
    }

    public static boolean renderItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text, boolean hideStackOverlay, Optional<Vec3> scaleOpt) {
        boolean retVal = false;
        if (stack != null && !stack.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(stack, (Level)mc.level, (LivingEntity)mc.player, 0);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 32.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean flag;
                guiGraphics.pose().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
                scaleOpt.ifPresent(scale -> guiGraphics.pose().scale((float)scale.x, (float)scale.y, (float)scale.z));
                boolean bl = flag = !bakedModel.usesBlockLight();
                if (flag) {
                    Lighting.setupForFlatItems();
                }
                itemRenderer.render(stack, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                guiGraphics.flush();
                if (flag) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Registry Name", () -> String.valueOf(Services.ITEMS_REGISTRY.getKey(stack.getItem())));
                crashreportcategory.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            guiGraphics.pose().popPose();
            if (!hideStackOverlay) {
                guiGraphics.renderItemDecorations(mc.font, stack, x, y, text);
            }
            guiGraphics.pose().popPose();
            retVal = true;
        }
        return retVal;
    }

    public static void renderItemTooltip(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        List lines = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        Services.GUI_GRAPHICS.renderComponentTooltip(guiGraphics, mc.font, lines, x, y, stack);
    }

    public static void renderCustomTooltip(GuiGraphics guiGraphics, List<Component> textList, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        Services.GUI_GRAPHICS.renderComponentTooltip(guiGraphics, mc.font, textList, x, y, ItemStack.EMPTY);
    }

    public static void renderComponentTooltipFromElements(GuiGraphics guiGraphics, List<Either<FormattedText, TooltipComponent>> elements, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        Services.GUI_GRAPHICS.renderComponentTooltipFromElements(guiGraphics, mc.font, elements, x, y, ItemStack.EMPTY);
    }

    public static void renderSourcesForPlayer(GuiGraphics guiGraphics, @Nullable SourceList sources, @Nullable Player player, int startX, int startY) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        guiGraphics.pose().pushPose();
        int x = 0;
        int index = 0;
        for (Source source : sources.getSourcesSorted()) {
            if (source == null) continue;
            x = startX + index * 18;
            if (source.isDiscovered(player)) {
                GuiUtils.renderSourceIcon(guiGraphics, x, startY, source, sources.getAmount(source), 998.0);
            } else {
                GuiUtils.renderUnknownSourceIcon(guiGraphics, x, startY, sources.getAmount(source), 998.0);
            }
            ++index;
        }
        guiGraphics.pose().popPose();
    }

    public static void renderSourceIcon(GuiGraphics guiGraphics, int x, int y, @Nullable Source source, int amount, double z) {
        if (source != null) {
            GuiUtils.renderSourceIcon(guiGraphics, x, y, source.getAtlasLocation(), amount, z);
        }
    }

    public static void renderUnknownSourceIcon(GuiGraphics guiGraphics, int x, int y, int amount, double z) {
        GuiUtils.renderSourceIcon(guiGraphics, x, y, Source.getUnknownAtlasLocation(), amount, z);
    }

    protected static void renderSourceIcon(GuiGraphics guiGraphics, int x, int y, @Nonnull ResourceLocation imageLoc, int amount, double z) {
        boolean isBlendOn = GL11.glIsEnabled((int)3042);
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().pushPose();
        TextureAtlasSprite sprite = mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(imageLoc);
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(RenderType.cutout());
        builder.addVertex((float)x + 0.0f, (float)y + 16.0f, (float)z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex((float)x + 16.0f, (float)y + 16.0f, (float)z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex((float)x + 16.0f, (float)y + 0.0f, (float)z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex((float)x + 0.0f, (float)y + 0.0f, (float)z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
        buffer.endBatch();
        guiGraphics.pose().popPose();
        if (amount > 0) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0, 0.0, z + 1.0);
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            String amountStr = Integer.toString(amount);
            int amountWidth = mc.font.width(amountStr);
            Font font = mc.font;
            Objects.requireNonNull(mc.font);
            guiGraphics.drawString(font, amountStr, 32 - amountWidth + x * 2, 32 - 9 + y * 2, Color.WHITE.getRGB());
            guiGraphics.pose().popPose();
        }
        if (!isBlendOn) {
            RenderSystem.disableBlend();
        }
        guiGraphics.pose().popPose();
    }

    public static void renderSourcesBillboard(PoseStack poseStack, MultiBufferSource buffers, double x, double y, double z, SourceList sources, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        double interpolatedPlayerX = mc.player.xo + (double)partialTicks * (mc.player.getX() - mc.player.xo);
        double interpolatedPlayerY = mc.player.yo + (double)partialTicks * (mc.player.getY() - mc.player.yo);
        double interpolatedPlayerZ = mc.player.zo + (double)partialTicks * (mc.player.getZ() - mc.player.zo);
        double dx = interpolatedPlayerX - x + 0.5;
        double dz = interpolatedPlayerZ - z + 0.5;
        float rotYaw = 180.0f + (float)(Mth.atan2((double)dx, (double)dz) * 180.0 / Math.PI);
        float scale = 0.03f;
        double shiftX = 0.0;
        double startDeltaX = 16.0 * (double)sources.getSources().size() / 2.0 * (double)scale;
        for (Source source : sources.getSourcesSorted()) {
            int amount = sources.getAmount(source);
            if (amount <= 0) continue;
            poseStack.pushPose();
            poseStack.translate(x - interpolatedPlayerX, y - interpolatedPlayerY - 0.5, z - interpolatedPlayerZ);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotYaw));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(shiftX - startDeltaX, 0.0, 0.0);
            poseStack.scale(scale, scale, scale);
            ResourceLocation texLoc = source.isDiscovered((Player)mc.player) ? source.getAtlasLocation() : Source.getUnknownAtlasLocation();
            TextureAtlasSprite sprite = mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(texLoc);
            VertexConsumer builder = buffers.getBuffer(RenderType.cutout());
            Matrix4f matrix = poseStack.last().pose();
            builder.addVertex(matrix, 0.0f, 16.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(matrix, 16.0f, 16.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(matrix, 16.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
            builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
            String amountStr = Integer.toString(amount);
            int amountWidth = mc.font.width(amountStr);
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, -0.5f);
            double d = 32.0 - (double)amountWidth;
            Objects.requireNonNull(mc.font);
            poseStack.translate(d, 32.0 - 9.0, 0.0);
            mc.font.drawInBatch(amountStr, 0.0f, 0.0f, Color.WHITE.getRGB(), true, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0, mc.font.isBidirectional());
            poseStack.popPose();
            poseStack.popPose();
            shiftX += 16.0 * (double)scale;
        }
    }

    public static void renderIconFromDefinition(GuiGraphics guiGraphics, IconDefinition iconDef, int x, int y) {
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        if (iconDef.isItem()) {
            GuiUtils.renderItemStack(guiGraphics, new ItemStack((ItemLike)iconDef.asItem()), 0, 0, null, true);
        } else if (iconDef.isTag()) {
            GuiUtils.renderItemStack(guiGraphics, GuiUtils.getTagDisplayStack(iconDef.asTagKey()), 0, 0, null, true);
        } else {
            guiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
            guiGraphics.blit(iconDef.getLocation(), 0, 0, 0, 0, 255, 255);
        }
        guiGraphics.pose().popPose();
    }

    protected static ItemStack getTagDisplayStack(TagKey<Item> key) {
        return GuiUtils.getTagDisplayStack(key, System.currentTimeMillis(), 1000L);
    }

    protected static ItemStack getTagDisplayStack(TagKey<Item> key, long time, long millisPerItem) {
        ArrayList tagContents = new ArrayList();
        Services.ITEMS_REGISTRY.getTag(key).forEach(tagContents::add);
        if (!tagContents.isEmpty()) {
            int index = (int)(time / millisPerItem % (long)tagContents.size());
            return new ItemStack((ItemLike)tagContents.get(index));
        }
        return ItemStack.EMPTY;
    }
}

