/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.toast;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToastPM
implements Toast {
    protected static final int DISPLAY_TIME = 5000;
    protected static final long TITLE_TIME = 1500L;
    protected static final float FADE_DURATION = 300.0f;

    protected abstract ResourceLocation getBackgroundSprite();

    protected abstract Component getTitleText();

    protected abstract Optional<Component> getSubtitleText();

    protected abstract Component getBodyText();

    protected abstract int getTitleColor();

    protected abstract int getSubtitleColor();

    protected abstract int getBodyColor();

    protected abstract Optional<ResourceLocation> getIcon();

    protected int getIconWidth() {
        return 16;
    }

    protected int getIconHeight() {
        return 16;
    }

    @NotNull
    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        int x = this.getIcon().isPresent() ? 30 : 6;
        int lineMax = this.getIcon().isPresent() ? 125 : 148;
        pGuiGraphics.blitSprite(this.getBackgroundSprite(), 0, 0, this.width(), this.height());
        List bodyLines = pToastComponent.getMinecraft().font.split((FormattedText)this.getBodyText(), lineMax);
        if (this.getSubtitleText().isPresent() && bodyLines.size() == 1) {
            if (pTimeSinceLastVisible < 1500L) {
                int titleFade = Mth.floor((float)(Mth.clamp((float)((float)(1500L - pTimeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getTitleText(), x, 7, this.getTitleColor() | titleFade, false);
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getSubtitleText().get(), x, 18, this.getSubtitleColor() | titleFade, false);
            } else {
                int bodyFade = Mth.floor((float)(Mth.clamp((float)((float)(pTimeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (FormattedCharSequence)bodyLines.getFirst(), x, 11, this.getBodyColor() | bodyFade, false);
            }
        } else if (this.getSubtitleText().isPresent()) {
            if (pTimeSinceLastVisible < 1500L) {
                int titleFade = Mth.floor((float)(Mth.clamp((float)((float)(1500L - pTimeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getTitleText(), x, 7, this.getTitleColor() | titleFade, false);
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getSubtitleText().get(), x, 18, this.getSubtitleColor() | titleFade, false);
            } else {
                int bodyFade = Mth.floor((float)(Mth.clamp((float)((float)(pTimeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                int y = this.height() / 2 - bodyLines.size() * 9 / 2;
                for (FormattedCharSequence formattedcharsequence : bodyLines) {
                    pGuiGraphics.drawString(pToastComponent.getMinecraft().font, formattedcharsequence, x, y, this.getBodyColor() | bodyFade, false);
                    y += 9;
                }
            }
        } else if (bodyLines.size() == 1) {
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getTitleText(), x, 7, this.getTitleColor() | 0xFF000000, false);
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (FormattedCharSequence)bodyLines.getFirst(), x, 18, this.getBodyColor(), false);
        } else if (pTimeSinceLastVisible < 1500L) {
            int titleFade = Mth.floor((float)(Mth.clamp((float)((float)(1500L - pTimeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            pGuiGraphics.drawString(pToastComponent.getMinecraft().font, this.getTitleText(), x, 11, this.getTitleColor() | titleFade, false);
        } else {
            int bodyFade = Mth.floor((float)(Mth.clamp((float)((float)(pTimeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int y = this.height() / 2 - bodyLines.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : bodyLines) {
                pGuiGraphics.drawString(pToastComponent.getMinecraft().font, formattedcharsequence, x, y, this.getBodyColor() | bodyFade, false);
                y += 9;
            }
        }
        this.getIcon().ifPresent(iconLoc -> {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(8.0f, 8.0f, 0.0f);
            pGuiGraphics.pose().scale((float)this.getIconWidth() / 256.0f, (float)this.getIconHeight() / 256.0f, 1.0f);
            pGuiGraphics.blit(iconLoc, 0, 0, 0, 0, 255, 255);
            pGuiGraphics.pose().popPose();
        });
        return (double)pTimeSinceLastVisible >= 5000.0 * pToastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

