/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaFontTER;
import com.verdantartifice.primalmagick.common.blocks.devices.AbstractWindGeneratorBlock;
import com.verdantartifice.primalmagick.common.tiles.devices.WindGeneratorTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WindGeneratorTER
implements BlockEntityRenderer<WindGeneratorTileEntity> {
    public WindGeneratorTER(BlockEntityRendererProvider.Context context) {
    }

    protected void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float r, float g, float b, float u, float v) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(r, g, b, 1.0f).setUv(u, v).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
    }

    public void render(WindGeneratorTileEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Color color;
        Minecraft mc = Minecraft.getInstance();
        BlockState state = tileEntityIn.getBlockState();
        Direction facing = (Direction)state.getValue((Property)AbstractWindGeneratorBlock.FACING);
        boolean powered = (Boolean)state.getValue((Property)AbstractWindGeneratorBlock.POWERED);
        long time = tileEntityIn.getLevel().getLevelData().getGameTime();
        Block block = state.getBlock();
        if (block instanceof AbstractWindGeneratorBlock) {
            AbstractWindGeneratorBlock windBlock = (AbstractWindGeneratorBlock)block;
            color = new Color(windBlock.getCoreColor());
        } else {
            color = Color.WHITE;
        }
        Color sourceColor = color;
        float r = (float)sourceColor.getRed() / 255.0f;
        float g = (float)sourceColor.getGreen() / 255.0f;
        float b = (float)sourceColor.getBlue() / 255.0f;
        float ds = 0.1875f;
        float rot = ((float)((int)(time % 360L)) + partialTicks) * (powered ? 30.0f : 1.0f);
        float scale = 0.9f;
        TextureAtlasSprite sprite = mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(ManaFontTER.TEXTURE);
        VertexConsumer builder = buffer.getBuffer(RenderType.solid());
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        if (!facing.getAxis().equals((Object)Direction.Axis.Y)) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            if (facing.getAxis().equals((Object)Direction.Axis.X)) {
                matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees(rot));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        matrixStack.scale(scale, scale, scale);
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        matrixStack.popPose();
    }
}

