/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaFontTER;
import com.verdantartifice.primalmagick.client.renderers.tile.model.SpellcraftingAltarRingModel;
import com.verdantartifice.primalmagick.common.blocks.crafting.SpellcraftingAltarBlock;
import com.verdantartifice.primalmagick.common.tiles.crafting.SpellcraftingAltarTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SpellcraftingAltarTER
implements BlockEntityRenderer<SpellcraftingAltarTileEntity> {
    public static final ResourceLocation RING_TEXTURE = ResourceUtils.loc("entity/spellcrafting_altar/spellcrafting_altar_ring");
    public static final Material RING_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, RING_TEXTURE);
    protected final SpellcraftingAltarRingModel ringModel;

    public SpellcraftingAltarTER(BlockEntityRendererProvider.Context context) {
        this.ringModel = new SpellcraftingAltarRingModel(context.bakeLayer(ModelLayersPM.SPELLCRAFTING_ALTAR_RING));
    }

    protected void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float r, float g, float b, float u, float v) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(r, g, b, 1.0f).setUv(u, v).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
    }

    public void render(SpellcraftingAltarTileEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        BlockState state = tileEntityIn.getBlockState();
        long time = tileEntityIn.getLevel().getLevelData().getGameTime();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0, 0.5);
        matrixStack.translate(0.0, 2.5, 0.0);
        double bobDelta = 0.125 * Math.sin(((double)time + (double)partialTicks) * 0.031415926535897934);
        matrixStack.translate(0.0, bobDelta, 0.0);
        float facingAngle = ((Direction)state.getValue((Property)SpellcraftingAltarBlock.FACING)).getClockWise().toYRot();
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(-facingAngle));
        matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(tileEntityIn.getCurrentRotation(partialTicks)));
        VertexConsumer ringBuilder = RING_MATERIAL.buffer(buffer, RenderType::entitySolid);
        this.ringModel.renderToBuffer(matrixStack, ringBuilder, combinedLight, combinedOverlay, -1);
        matrixStack.popPose();
        Color sourceColor = tileEntityIn.getCurrentColor(partialTicks);
        float r = (float)sourceColor.getRed() / 255.0f;
        float g = (float)sourceColor.getGreen() / 255.0f;
        float b = (float)sourceColor.getBlue() / 255.0f;
        float ds = 0.1875f;
        int rot = (int)(time % 360L);
        float scale = 0.5f;
        TextureAtlasSprite sprite = mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(ManaFontTER.TEXTURE);
        VertexConsumer builder = buffer.getBuffer(RenderType.solid());
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.125, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)rot));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        matrixStack.scale(scale, scale, scale);
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, sprite.getU0(), sprite.getV0());
        matrixStack.popPose();
        FxDispatcher.INSTANCE.spellcraftingGlow(tileEntityIn.getBlockPos(), 1.125, r, g, b);
    }
}

