/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.tiles.devices.SanguineCrucibleTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class SanguineCrucibleTER
implements BlockEntityRenderer<SanguineCrucibleTileEntity> {
    protected static final ResourceLocation WATER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");
    protected static final Color COLOR = new Color(Sources.BLOOD.getColor()).brighter().brighter();
    protected static final float R = (float)COLOR.getRed() / 255.0f;
    protected static final float G = (float)COLOR.getGreen() / 255.0f;
    protected static final float B = (float)COLOR.getBlue() / 255.0f;

    public SanguineCrucibleTER(BlockEntityRendererProvider.Context context) {
    }

    public void render(SanguineCrucibleTileEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        double z;
        double y;
        double x;
        Minecraft mc = Minecraft.getInstance();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, (double)tileEntityIn.getFluidHeight(), 0.0);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        TextureAtlasSprite sprite = mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(WATER_TEXTURE);
        VertexConsumer builder = bufferIn.getBuffer(RenderType.solid());
        Matrix4f matrix = matrixStackIn.last().pose();
        builder.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(R, G, B, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setUv2(0, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(R, G, B, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setUv2(0, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(R, G, B, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setUv2(0, 240).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(R, G, B, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setUv2(0, 240).setNormal(1.0f, 0.0f, 0.0f);
        matrixStackIn.popPose();
        Level world = tileEntityIn.getLevel();
        RandomSource rand = world.random;
        BlockPos pos = tileEntityIn.getBlockPos();
        if (tileEntityIn.showBubble(rand)) {
            x = (double)pos.getX() + 0.2 + rand.nextDouble() * 0.6;
            y = (double)pos.getY() + (double)tileEntityIn.getFluidHeight();
            z = (double)pos.getZ() + 0.2 + rand.nextDouble() * 0.6;
            FxDispatcher.INSTANCE.crucibleBubble(x, y, z, R, G, B);
        }
        if (rand.nextDouble() < tileEntityIn.getSmokeChance()) {
            x = (double)pos.getX() + 0.1 + rand.nextDouble() * 0.8;
            y = (double)pos.getY() + 1.0;
            z = (double)pos.getZ() + 0.1 + rand.nextDouble() * 0.8;
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.1, 0.0);
        }
    }
}

