/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaFontTER;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RitualAltarTER
implements BlockEntityRenderer<RitualAltarTileEntity> {
    public RitualAltarTER(BlockEntityRendererProvider.Context context) {
    }

    protected void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setUv2(240, 240).setNormal(1.0f, 0.0f, 0.0f);
    }

    protected void renderCube(VertexConsumer builder, PoseStack matrixStack, float ds, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, a, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, ds, -ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV0());
        this.addVertex(builder, matrixStack, -ds, ds, ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, ds, ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, ds, -ds, -ds, r, g, b, a, sprite.getU1(), sprite.getV0());
        this.addVertex(builder, matrixStack, ds, -ds, ds, r, g, b, a, sprite.getU1(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, ds, r, g, b, a, sprite.getU0(), sprite.getV1());
        this.addVertex(builder, matrixStack, -ds, -ds, -ds, r, g, b, a, sprite.getU0(), sprite.getV0());
    }

    public void render(RitualAltarTileEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = tileEntityIn.getSyncedStack().copy();
        if (!stack.isEmpty()) {
            int rot = (int)(tileEntityIn.getLevel().getLevelData().getGameTime() % 360L);
            matrixStack.pushPose();
            matrixStack.translate(0.5, 1.5, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees((float)rot));
            matrixStack.scale(0.75f, 0.75f, 0.75f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, combinedLightIn, combinedOverlayIn, matrixStack, buffer, tileEntityIn.getLevel(), 0);
            matrixStack.popPose();
        }
        if (tileEntityIn.isActive()) {
            Color color = tileEntityIn.getOrbColor();
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            float ds = 0.1875f;
            float ticks = (float)tileEntityIn.getActiveCount() + partialTicks;
            TextureAtlasSprite sprite = mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(ManaFontTER.TEXTURE);
            VertexConsumer builder = buffer.getBuffer(RenderType.solid());
            matrixStack.pushPose();
            matrixStack.translate(0.5, 2.5, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(ticks * 0.1f)) * 180.0f));
            matrixStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(ticks * 0.1f)) * 180.0f));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(ticks * 0.15f)) * 360.0f));
            this.renderCube(builder, matrixStack, ds, r, g, b, 1.0f, sprite);
            matrixStack.popPose();
            FxDispatcher.INSTANCE.ritualGlow(tileEntityIn.getBlockPos(), color.getRGB());
        }
    }
}

