/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaCubeModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaRelayFrameModel;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaRelayTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class ManaRelayTER
implements BlockEntityRenderer<ManaRelayTileEntity> {
    public static final ResourceLocation CORE_TEXTURE = ResourceUtils.loc("entity/mana_cube");
    private static final Material CORE_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, CORE_TEXTURE);
    public static final ResourceLocation BASIC_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/basic_frame");
    public static final ResourceLocation ENCHANTED_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/enchanted_frame");
    public static final ResourceLocation FORBIDDEN_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/forbidden_frame");
    public static final ResourceLocation HEAVENLY_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/heavenly_frame");
    private static final Material BASIC_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BASIC_FRAME_TEXTURE);
    private static final Material ENCHANTED_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, ENCHANTED_FRAME_TEXTURE);
    private static final Material FORBIDDEN_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, FORBIDDEN_FRAME_TEXTURE);
    private static final Material HEAVENLY_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, HEAVENLY_FRAME_TEXTURE);
    protected final ManaRelayFrameModel frameModel;
    protected final ManaCubeModel manaCubeModel;

    public ManaRelayTER(BlockEntityRendererProvider.Context context) {
        this.frameModel = new ManaRelayFrameModel(context.bakeLayer(ModelLayersPM.MANA_RELAY_FRAME));
        this.manaCubeModel = new ManaCubeModel(context.bakeLayer(ModelLayersPM.MANA_CUBE));
    }

    public void render(ManaRelayTileEntity manaRelayTileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        DeviceTier tier = manaRelayTileEntity.getDeviceTier();
        long time = manaRelayTileEntity.getLevel().getLevelData().getGameTime();
        double bobDelta = 0.125 * Math.sin(((double)time + (double)partialTicks) * 0.031415926535897934);
        int rot = 2 * (int)(time % 360L);
        float baseScale = 0.5f;
        float tilt = 45.0f;
        int coreColor = manaRelayTileEntity.getCurrentColor(partialTicks);
        poseStack.pushPose();
        poseStack.translate(0.0, bobDelta, 0.0);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(-rot)));
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        VertexConsumer frameBuilder = this.getFrameMaterial(tier).buffer(multiBufferSource, RenderType::entitySolid);
        this.frameModel.renderToBuffer(poseStack, frameBuilder, combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        float coreScale = 0.375f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)rot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.scale(0.375f, 0.375f, 0.375f);
        VertexConsumer ringBuilder = CORE_MATERIAL.buffer(multiBufferSource, RenderType::entitySolid);
        this.manaCubeModel.renderToBuffer(poseStack, ringBuilder, combinedLight, combinedOverlay, coreColor);
        poseStack.popPose();
        poseStack.popPose();
        FxDispatcher.INSTANCE.spellcraftingGlow(manaRelayTileEntity.getBlockPos(), 0.5 + bobDelta, coreColor);
    }

    protected Material getFrameMaterial(DeviceTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> BASIC_FRAME_MATERIAL;
            case DeviceTier.ENCHANTED -> ENCHANTED_FRAME_MATERIAL;
            case DeviceTier.FORBIDDEN -> FORBIDDEN_FRAME_MATERIAL;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> HEAVENLY_FRAME_MATERIAL;
        };
    }
}

