/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaCubeModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaInjectorFrameRingBottomMiddleModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaInjectorFrameRingBottomModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaInjectorFrameRingTopMiddleModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaInjectorFrameRingTopModel;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaInjectorTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Math;

public class ManaInjectorTER
implements BlockEntityRenderer<ManaInjectorTileEntity> {
    public static final ResourceLocation CORE_TEXTURE = ResourceUtils.loc("entity/mana_cube");
    private static final Material CORE_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, CORE_TEXTURE);
    public static final ResourceLocation BASIC_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_injector/basic_frame_top");
    public static final ResourceLocation ENCHANTED_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_injector/enchanted_frame_top");
    public static final ResourceLocation FORBIDDEN_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_injector/forbidden_frame_top");
    public static final ResourceLocation HEAVENLY_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_injector/heavenly_frame_top");
    public static final ResourceLocation BOTTOM_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_injector/frame_bottom");
    private static final Material BASIC_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BASIC_FRAME_TEXTURE);
    private static final Material ENCHANTED_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, ENCHANTED_FRAME_TEXTURE);
    private static final Material FORBIDDEN_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, FORBIDDEN_FRAME_TEXTURE);
    private static final Material HEAVENLY_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, HEAVENLY_FRAME_TEXTURE);
    private static final Material BOTTOM_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BOTTOM_FRAME_TEXTURE);
    protected final ManaInjectorFrameRingTopModel ringTopModel;
    protected final ManaInjectorFrameRingTopMiddleModel ringTopMiddleModel;
    protected final ManaInjectorFrameRingBottomMiddleModel ringBottomMiddleModel;
    protected final ManaInjectorFrameRingBottomModel ringBottomModel;
    protected final ManaCubeModel manaCubeModel;
    protected static final int DIP_DURATION = 8;
    protected static final int CYCLE_DURATION = 40;

    public ManaInjectorTER(BlockEntityRendererProvider.Context context) {
        this.ringTopModel = new ManaInjectorFrameRingTopModel(context.bakeLayer(ModelLayersPM.MANA_INJECTOR_FRAME_TOP));
        this.ringTopMiddleModel = new ManaInjectorFrameRingTopMiddleModel(context.bakeLayer(ModelLayersPM.MANA_INJECTOR_FRAME_TOP_MIDDLE));
        this.ringBottomMiddleModel = new ManaInjectorFrameRingBottomMiddleModel(context.bakeLayer(ModelLayersPM.MANA_INJECTOR_FRAME_BOTTOM_MIDDLE));
        this.ringBottomModel = new ManaInjectorFrameRingBottomModel(context.bakeLayer(ModelLayersPM.MANA_INJECTOR_FRAME_BOTTOM));
        this.manaCubeModel = new ManaCubeModel(context.bakeLayer(ModelLayersPM.MANA_CUBE));
    }

    public void render(ManaInjectorTileEntity manaInjectorTileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        DeviceTier tier = manaInjectorTileEntity.getDeviceTier();
        long time = manaInjectorTileEntity.getLevel().getLevelData().getGameTime();
        int rot = 2 * (int)(time % 360L);
        float tilt = 45.0f;
        int coreColor = manaInjectorTileEntity.getCurrentColor(partialTicks);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        VertexConsumer topFrameBuilder = this.getTopFrameMaterial(tier).buffer(multiBufferSource, RenderType::entitySolid);
        VertexConsumer bottomFrameBuilder = BOTTOM_FRAME_MATERIAL.buffer(multiBufferSource, RenderType::entitySolid);
        poseStack.pushPose();
        poseStack.translate(0.0, 1.875 + this.getDipAmount(time, partialTicks, 0), 0.0);
        this.ringTopModel.renderToBuffer(poseStack, topFrameBuilder, combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 1.375 + this.getDipAmount(time, partialTicks, 4), 0.0);
        this.ringTopMiddleModel.renderToBuffer(poseStack, bottomFrameBuilder, combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.875 + this.getDipAmount(time, partialTicks, 8), 0.0);
        this.ringBottomMiddleModel.renderToBuffer(poseStack, bottomFrameBuilder, combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.375 + this.getDipAmount(time, partialTicks, 12), 0.0);
        this.ringBottomModel.renderToBuffer(poseStack, bottomFrameBuilder, combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        poseStack.popPose();
        float coreScale = 0.1875f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.75, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)rot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.1875f, 0.1875f, 0.1875f);
        VertexConsumer ringBuilder = CORE_MATERIAL.buffer(multiBufferSource, RenderType::entitySolid);
        this.manaCubeModel.renderToBuffer(poseStack, ringBuilder, combinedLight, combinedOverlay, coreColor);
        poseStack.popPose();
        FxDispatcher.INSTANCE.spellcraftingGlow(manaInjectorTileEntity.getBlockPos(), 0.75, coreColor);
    }

    protected double getDipAmount(long gameTime, float partialTicks, int dipStartTime) {
        double cycleTime = (double)(gameTime % 40L) + (double)partialTicks;
        if (cycleTime >= (double)dipStartTime && cycleTime <= (double)(dipStartTime + 8)) {
            return -0.125 * Math.sin((double)((cycleTime - (double)dipStartTime) * 0.39269908169872414));
        }
        return 0.0;
    }

    protected Material getTopFrameMaterial(DeviceTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> BASIC_FRAME_MATERIAL;
            case DeviceTier.ENCHANTED -> ENCHANTED_FRAME_MATERIAL;
            case DeviceTier.FORBIDDEN -> FORBIDDEN_FRAME_MATERIAL;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> HEAVENLY_FRAME_MATERIAL;
        };
    }
}

