/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.itemstack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.verdantartifice.primalmagick.common.items.tools.SpelltomeItem;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SpelltomeISTER
extends BlockEntityWithoutLevelRenderer {
    protected static final ResourceLocation TEXTURE_APPRENTICE = ResourceUtils.loc("textures/entity/spelltome/apprentice.png");
    protected static final ResourceLocation TEXTURE_ADEPT = ResourceUtils.loc("textures/entity/spelltome/adept.png");
    protected static final ResourceLocation TEXTURE_WIZARD = ResourceUtils.loc("textures/entity/spelltome/wizard.png");
    protected static final ResourceLocation TEXTURE_ARCHMAGE = ResourceUtils.loc("textures/entity/spelltome/archmage.png");
    protected BookModel model;

    public SpelltomeISTER() {
        super(Minecraft.getInstance() == null ? null : Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance() == null ? null : Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager pResourceManager) {
        this.model = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    public void renderByItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Item item = pStack.getItem();
        if (item instanceof SpelltomeItem) {
            SpelltomeItem spelltomeItem = (SpelltomeItem)item;
            float open = pDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || pDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND ? 1.0f : 0.0f;
            pPoseStack.pushPose();
            pPoseStack.scale(1.0f, -1.0f, -1.0f);
            this.model.setupAnim(0.0f, 0.1f, 0.9f, open);
            VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBuffer, (RenderType)this.model.renderType(SpelltomeISTER.getTextureLocation(spelltomeItem.getDeviceTier())), (boolean)false, (boolean)pStack.hasFoil());
            this.model.renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, pPackedOverlay, -1);
            pPoseStack.popPose();
        }
    }

    private static ResourceLocation getTextureLocation(DeviceTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> TEXTURE_APPRENTICE;
            case DeviceTier.ENCHANTED -> TEXTURE_ADEPT;
            case DeviceTier.FORBIDDEN -> TEXTURE_WIZARD;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> TEXTURE_ARCHMAGE;
        };
    }
}

