/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.itemstack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.client.renderers.tile.model.SpellcraftingAltarRingModel;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.crafting.SpellcraftingAltarBlock;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class SpellcraftingAltarISTER
extends BlockEntityWithoutLevelRenderer {
    private static final ModelResourceLocation MRL = BlockModelShaper.stateToModelLocation((BlockState)BlocksPM.SPELLCRAFTING_ALTAR.get().defaultBlockState());
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("entity/spellcrafting_altar/spellcrafting_altar_ring");
    private static final Material RING_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE);
    protected SpellcraftingAltarRingModel model;

    public SpellcraftingAltarISTER() {
        super(Minecraft.getInstance() == null ? null : Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance() == null ? null : Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.model = new SpellcraftingAltarRingModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayersPM.SPELLCRAFTING_ALTAR_RING));
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockItem blockItem;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SpellcraftingAltarBlock) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            VertexConsumer builder = buffer.getBuffer(RenderType.solid());
            BakedModel model = mc.getModelManager().getModel(MRL);
            itemRenderer.renderModelLists(model, itemStack, combinedLight, combinedOverlay, matrixStack, builder);
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0, 0.5);
            matrixStack.translate(0.0, 2.4, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer ringBuilder = RING_MATERIAL.buffer(buffer, RenderType::entitySolid);
            this.model.renderToBuffer(matrixStack, ringBuilder, combinedLight, combinedOverlay, -1);
            matrixStack.popPose();
        }
    }
}

