/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.itemstack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaCubeModel;
import com.verdantartifice.primalmagick.client.renderers.tile.model.ManaRelayFrameModel;
import com.verdantartifice.primalmagick.common.blocks.mana.ManaRelayBlock;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ManaRelayISTER
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation CORE_TEXTURE = ResourceUtils.loc("entity/mana_cube");
    private static final Material CORE_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, CORE_TEXTURE);
    private static final ResourceLocation BASIC_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/basic_frame");
    private static final ResourceLocation ENCHANTED_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/enchanted_frame");
    private static final ResourceLocation FORBIDDEN_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/forbidden_frame");
    private static final ResourceLocation HEAVENLY_FRAME_TEXTURE = ResourceUtils.loc("entity/mana_relay/heavenly_frame");
    private static final Material BASIC_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BASIC_FRAME_TEXTURE);
    private static final Material ENCHANTED_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, ENCHANTED_FRAME_TEXTURE);
    private static final Material FORBIDDEN_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, FORBIDDEN_FRAME_TEXTURE);
    private static final Material HEAVENLY_FRAME_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, HEAVENLY_FRAME_TEXTURE);
    protected ManaRelayFrameModel frameModel;
    protected ManaCubeModel cubeModel;

    public ManaRelayISTER() {
        super(Minecraft.getInstance() == null ? null : Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance() == null ? null : Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager pResourceManager) {
        Minecraft mc = Minecraft.getInstance();
        this.frameModel = new ManaRelayFrameModel(mc.getEntityModels().bakeLayer(ModelLayersPM.MANA_RELAY_FRAME));
        this.cubeModel = new ManaCubeModel(mc.getEntityModels().bakeLayer(ModelLayersPM.MANA_CUBE));
    }

    public void renderByItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockItem blockItem;
        Item item = pStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ManaRelayBlock) {
            ManaRelayBlock relayBlock = (ManaRelayBlock)item;
            float baseScale = 0.5f;
            float tilt = 45.0f;
            pPoseStack.pushPose();
            pPoseStack.translate(0.5, 0.5, 0.5);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            VertexConsumer frameBuilder = this.getFrameMaterial(relayBlock.getDeviceTier()).buffer(pBuffer, RenderType::entitySolid);
            this.frameModel.renderToBuffer(pPoseStack, frameBuilder, pPackedLight, pPackedOverlay, -1);
            pPoseStack.popPose();
            float coreScale = 0.375f;
            pPoseStack.pushPose();
            pPoseStack.translate(0.5, 0.5, 0.5);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            pPoseStack.scale(0.5f, 0.5f, 0.5f);
            pPoseStack.scale(0.375f, 0.375f, 0.375f);
            VertexConsumer ringBuilder = CORE_MATERIAL.buffer(pBuffer, RenderType::entitySolid);
            this.cubeModel.renderToBuffer(pPoseStack, ringBuilder, pPackedLight, pPackedOverlay, Sources.SKY.getColor());
            pPoseStack.popPose();
        }
    }

    private Material getFrameMaterial(DeviceTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case DeviceTier.BASIC -> BASIC_FRAME_MATERIAL;
            case DeviceTier.ENCHANTED -> ENCHANTED_FRAME_MATERIAL;
            case DeviceTier.FORBIDDEN -> FORBIDDEN_FRAME_MATERIAL;
            case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> HEAVENLY_FRAME_MATERIAL;
        };
    }
}

