/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.itemstack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.common.items.misc.ArcanometerItem;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ArcanometerISTER
extends BlockEntityWithoutLevelRenderer {
    private static final ModelResourceLocation MRL0 = Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_0"));
    private static final ModelResourceLocation MRL1 = Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_1"));
    private static final ModelResourceLocation MRL2 = Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_2"));
    private static final ModelResourceLocation MRL3 = Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_3"));
    private static final ModelResourceLocation MRL4 = Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_4"));
    private static AtomicBoolean isRenderingScreen = new AtomicBoolean(false);

    public ArcanometerISTER() {
        super(Minecraft.getInstance() == null ? null : Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance() == null ? null : Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemStack.getItem() instanceof ArcanometerItem) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            BakedModel model = mc.getModelManager().getModel(this.getModelResourceLocation(itemStack));
            itemRenderer.renderModelLists(model, itemStack, combinedLight, combinedOverlay, matrixStack, buffer.getBuffer(RenderType.solid()));
            if (!isRenderingScreen.getAndSet(true)) {
                ItemStack screenStack = ItemStack.EMPTY;
                HitResult result = RayTraceUtils.getMouseOver((Level)mc.level, (Player)mc.player);
                if (result != null) {
                    if (result.getType() == HitResult.Type.ENTITY) {
                        Entity entity = ((EntityHitResult)result).getEntity();
                        if (entity != null) {
                            screenStack = EntityUtils.getEntityItemStack(entity);
                            if (!screenStack.isEmpty()) {
                                this.renderScreenItem(itemRenderer, screenStack, matrixStack, buffer, combinedLight, combinedOverlay);
                            } else if (Services.PART_ENTITIES.isPartEntity(entity)) {
                                this.renderScreenEntity(mc.getEntityRenderDispatcher(), Services.PART_ENTITIES.getParent(entity), matrixStack, buffer, combinedLight, combinedOverlay);
                            } else {
                                this.renderScreenEntity(mc.getEntityRenderDispatcher(), entity, matrixStack, buffer, combinedLight, combinedOverlay);
                            }
                        }
                    } else if (result.getType() == HitResult.Type.BLOCK) {
                        screenStack = new ItemStack((ItemLike)mc.level.getBlockState(((BlockHitResult)result).getBlockPos()).getBlock());
                        this.renderScreenItem(itemRenderer, screenStack, matrixStack, buffer, combinedLight, combinedOverlay);
                    }
                }
                isRenderingScreen.set(false);
            }
        }
    }

    private void renderScreenItem(ItemRenderer itemRenderer, ItemStack screenStack, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.4375, 0.405);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.scale(0.2f, 0.2f, 1.0E-4f);
        itemRenderer.renderStatic(screenStack, ItemDisplayContext.GUI, combinedLight, combinedOverlay, matrixStack, buffer, (Level)mc.level, 0);
        matrixStack.popPose();
    }

    private void renderScreenEntity(EntityRenderDispatcher erm, Entity entity, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        float scale = 0.175f;
        float size = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if ((double)size > 1.0) {
            scale /= size;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.35, 0.405);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.scale(scale, scale, 1.0E-4f);
        erm.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, buffer, combinedLight);
        matrixStack.popPose();
    }

    protected ModelResourceLocation getModelResourceLocation(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        ItemPropertyFunction propGetter = ItemProperties.getProperty((ItemStack)stack, (ResourceLocation)ArcanometerItem.SCAN_STATE_PROPERTY);
        if (propGetter != null) {
            float value = propGetter.call(stack, mc.level, (LivingEntity)mc.player, 0);
            if (value <= 0.0f) {
                return MRL0;
            }
            if (value <= 0.25f) {
                return MRL1;
            }
            if (value <= 0.5f) {
                return MRL2;
            }
            if (value <= 0.75f) {
                return MRL3;
            }
            return MRL4;
        }
        return MRL0;
    }
}

