/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.itemstack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.verdantartifice.primalmagick.common.items.tools.AbstractTieredShieldItem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public abstract class AbstractTieredShieldISTER
extends BlockEntityWithoutLevelRenderer {
    protected ShieldModel model;

    public AbstractTieredShieldISTER() {
        super(Minecraft.getInstance() == null ? null : Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance() == null ? null : Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.model = new ShieldModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.SHIELD));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (stack.getItem() instanceof AbstractTieredShieldItem) {
            BannerPatternLayers layers = (BannerPatternLayers)stack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            DyeColor dyeColor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
            boolean hasPattern = !layers.layers().isEmpty() || dyeColor != null;
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            Material renderMaterial = this.getRenderMaterial(hasPattern);
            VertexConsumer vertexBuilder = renderMaterial.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(renderMaterial.atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            this.model.handle().render(poseStack, vertexBuilder, combinedLight, combinedOverlay, -1);
            if (hasPattern) {
                BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)buffer, (int)combinedLight, (int)combinedOverlay, (ModelPart)this.model.plate(), (Material)renderMaterial, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)layers, (boolean)stack.hasFoil());
            } else {
                this.model.plate().render(poseStack, vertexBuilder, combinedLight, combinedOverlay, -1);
            }
            poseStack.popPose();
        }
    }

    protected abstract Material getRenderMaterial(boolean var1);
}

