/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity.model;

import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkArmPose;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class TreefolkModel<T extends Mob>
extends HumanoidModel<T> {
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public TreefolkModel(ModelPart pRoot) {
        super(pRoot);
        this.bodyDefault = this.body.storePose();
        this.headDefault = this.head.storePose();
        this.leftArmDefault = this.leftArm.storePose();
        this.rightArmDefault = this.rightArm.storePose();
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.body.loadPose(this.bodyDefault);
        this.head.loadPose(this.headDefault);
        this.leftArm.loadPose(this.leftArmDefault);
        this.rightArm.loadPose(this.rightArmDefault);
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        if (pEntity instanceof TreefolkEntity) {
            TreefolkEntity treefolk = (TreefolkEntity)((Object)pEntity);
            TreefolkArmPose armPose = treefolk.getArmPose();
            if (armPose == TreefolkArmPose.ADMIRING_ITEM) {
                this.head.xRot = 0.5f;
                this.head.yRot = 0.0f;
                if (pEntity.isLeftHanded()) {
                    this.rightArm.yRot = -0.5f;
                    this.rightArm.xRot = -0.9f;
                } else {
                    this.leftArm.yRot = 0.5f;
                    this.leftArm.xRot = -0.9f;
                }
            } else if (armPose == TreefolkArmPose.DANCING) {
                float ageModVal = pAgeInTicks / 60.0f;
                this.head.x = Mth.sin((float)(ageModVal * 10.0f));
                this.head.y = Mth.sin((float)(ageModVal * 40.0f)) + 0.4f;
                this.rightArm.xRot = (float)Math.PI / 180 * (Mth.sin((float)(ageModVal * 40.0f)) * 30.0f);
                this.rightArm.zRot = (float)Math.PI / 180 * (40.0f + Mth.cos((float)(ageModVal * 40.0f)) * 10.0f);
                this.leftArm.xRot = this.rightArm.xRot * -1.0f;
                this.leftArm.zRot = this.rightArm.zRot * -1.0f;
                this.rightArm.y = Mth.sin((float)(ageModVal * 40.0f)) * 0.5f + 1.5f;
                this.leftArm.y = Mth.sin((float)(ageModVal * 40.0f)) * 0.5f + 1.5f;
                this.body.y = Mth.sin((float)(ageModVal * 40.0f)) * 0.35f;
            }
        }
    }
}

