/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.verdantartifice.primalmagick.common.entities.misc.PixieHouseEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PixieHouseModel
extends EntityModel<PixieHouseEntity> {
    private final ModelPart trunk;
    private final ModelPart support1;
    private final ModelPart support2;
    private final ModelPart support3;
    private final ModelPart branch1;
    private final ModelPart branch2;
    private final ModelPart house;

    public PixieHouseModel(ModelPart root) {
        this.trunk = root.getChild("trunk");
        this.support1 = root.getChild("support1");
        this.support2 = root.getChild("support2");
        this.support3 = root.getChild("support3");
        this.branch1 = root.getChild("branch1");
        this.branch2 = root.getChild("branch2");
        this.house = root.getChild("house");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition trunk = partdefinition.addOrReplaceChild("trunk", CubeListBuilder.create().texOffs(20, 26).addBox(-2.5f, 2.0f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)15.0f, (float)0.5f));
        PartDefinition support1 = partdefinition.addOrReplaceChild("support1", CubeListBuilder.create(), PartPose.offset((float)-0.8f, (float)13.0f, (float)-0.5f));
        PartDefinition leaves_r1 = support1.addOrReplaceChild("leaves_r1", CubeListBuilder.create().texOffs(8, 43).addBox(-2.0f, -6.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.1f, (float)-6.7f, (float)-4.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition upper_r1 = support1.addOrReplaceChild("upper_r1", CubeListBuilder.create().texOffs(4, 47).addBox(-1.0f, -4.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-6.0f, (float)-3.2f, (float)0.5064f, (float)0.9341f, (float)0.343f));
        PartDefinition mid_r1 = support1.addOrReplaceChild("mid_r1", CubeListBuilder.create().texOffs(36, 45).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.9f, (float)-4.3f, (float)-2.2f, (float)0.3927f, (float)1.0472f, (float)0.0f));
        PartDefinition lower_r1 = support1.addOrReplaceChild("lower_r1", CubeListBuilder.create().texOffs(36, 35).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8f, (float)1.0f, (float)0.5f, (float)0.7854f, (float)1.0472f, (float)0.0f));
        PartDefinition support2 = partdefinition.addOrReplaceChild("support2", CubeListBuilder.create(), PartPose.offset((float)1.1f, (float)14.0f, (float)-0.7f));
        PartDefinition leaves_r2 = support2.addOrReplaceChild("leaves_r2", CubeListBuilder.create().texOffs(30, 15).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-14.0f, (float)-2.5f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition upper_r2 = support2.addOrReplaceChild("upper_r2", CubeListBuilder.create().texOffs(20, 47).addBox(-1.0f, -4.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.6f, (float)-10.0f, (float)-3.2f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition mid_r2 = support2.addOrReplaceChild("mid_r2", CubeListBuilder.create().texOffs(44, 35).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.6f, (float)-4.1f, (float)-2.0f, (float)0.1472f, (float)-1.0607f, (float)-0.02f));
        PartDefinition lower_r2 = support2.addOrReplaceChild("lower_r2", CubeListBuilder.create().texOffs(20, 37).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1f, (float)1.0f, (float)0.7f, (float)0.7854f, (float)-1.0472f, (float)0.0f));
        PartDefinition support3 = partdefinition.addOrReplaceChild("support3", CubeListBuilder.create().texOffs(0, 47).addBox(-0.5f, -18.0f, 4.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-2.5f, -23.0f, 2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)1.3f));
        PartDefinition mid_r3 = support3.addOrReplaceChild("mid_r3", CubeListBuilder.create().texOffs(0, 36).addBox(-0.91f, -9.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-4.7f, (float)2.6f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition lower_r3 = support3.addOrReplaceChild("lower_r3", CubeListBuilder.create().texOffs(28, 37).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-1.3f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition branch1 = partdefinition.addOrReplaceChild("branch1", CubeListBuilder.create().texOffs(36, 23).addBox(-1.5f, -8.0f, -4.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.5f));
        PartDefinition body_r1 = branch1.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(46, 15).addBox(0.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition branch2 = partdefinition.addOrReplaceChild("branch2", CubeListBuilder.create().texOffs(36, 29).addBox(1.5f, -10.0f, 1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.2f, (float)19.0f, (float)1.4f));
        PartDefinition body_r2 = branch2.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(44, 44).addBox(0.0f, -2.0f, 0.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.8f, (float)-6.0f, (float)2.5f, (float)-0.5236f, (float)0.7854f, (float)0.0f));
        PartDefinition house = partdefinition.addOrReplaceChild("house", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 1.0f, -5.5f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-3.0f, -1.0f, -4.5f, 6.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(PixieHouseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = ageInTicks - (float)entity.tickCount;
        float timeSinceLastHit = (float)(entity.level().getGameTime() - entity.lastHit) + partialTicks;
        if (timeSinceLastHit < 5.0f) {
            float rot = 0.1f * Mth.sin((float)(timeSinceLastHit / 2.5f * (float)Math.PI));
            this.support1.zRot = -rot;
            this.support2.zRot = rot;
            this.support3.xRot = rot;
        } else {
            this.support1.zRot = 0.0f;
            this.support2.zRot = 0.0f;
            this.support3.xRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.trunk.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.support1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.support2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.support3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.branch1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.branch2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.house.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

