/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity.model;

import com.verdantartifice.primalmagick.common.entities.pixies.guardians.AbstractGuardianPixieEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class GuardianPixieModel
extends HierarchicalModel<AbstractGuardianPixieEntity> {
    protected final ModelPart root;
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightWing;
    protected final ModelPart leftWing;

    public GuardianPixieModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.getChild("head");
        this.body = modelPart.getChild("body");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer(boolean includeCrown) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition rootPart = mesh.getRoot();
        PartDefinition headPart = rootPart.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        if (includeCrown) {
            PartDefinition crownPart = headPart.addOrReplaceChild("crown", CubeListBuilder.create().texOffs(0, 29).addBox(-3.5f, -3.5f, -3.5f, 6.0f, 1.0f, 1.0f).texOffs(0, 32).addBox(-1.5f, -4.5f, -3.5f, 3.0f, 1.0f, 1.0f).texOffs(1, 29).addBox(-0.5f, -5.5f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
            crownPart.addOrReplaceChild("rim4", CubeListBuilder.create().texOffs(0, 29).addBox(-3.5f, -3.5f, -3.5f, 6.0f, 1.0f, 1.0f), PartPose.rotation((float)0.0f, (float)-1.5708f, (float)0.0f));
            crownPart.addOrReplaceChild("rim3", CubeListBuilder.create().texOffs(0, 29).addBox(-3.5f, -3.5f, -3.5f, 6.0f, 1.0f, 1.0f), PartPose.rotation((float)0.0f, (float)3.1416f, (float)0.0f));
            crownPart.addOrReplaceChild("rim2", CubeListBuilder.create().texOffs(0, 29).addBox(-3.5f, -3.5f, -3.5f, 6.0f, 1.0f, 1.0f), PartPose.rotation((float)0.0f, (float)1.5708f, (float)0.0f));
        }
        PartDefinition bodyPart = rootPart.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 13).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 11.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(22, 15).mirror().addBox(2.0f, -10.0f, 2.5f, 18.0f, 35.0f, 1.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 15).addBox(-20.0f, -10.0f, 2.5f, 18.0f, 35.0f, 1.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(25, 0).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(25, 0).mirror().addBox(-1.0f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f), PartPose.offset((float)-2.0f, (float)11.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-2.0f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f), PartPose.offset((float)2.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@Nullable AbstractGuardianPixieEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = entityIn == null ? 0.0f : netHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        if (entityIn == null) {
            this.head.setPos(0.0f, 1.0f, 0.0f);
        } else {
            this.head.setPos(0.0f, 0.0f, 0.0f);
        }
        if (entityIn == null || entityIn.getDeltaMovement().lengthSqr() > 0.0) {
            this.body.xRot = 0.3926991f;
        }
        this.body.yRot = 0.0f;
        this.rightWing.setPos(0.0f, 0.0f, 0.0f);
        this.leftWing.setPos(0.0f, 0.0f, 0.0f);
        this.rightWing.yRot = Mth.cos((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f;
        this.leftWing.yRot = -this.rightWing.yRot;
    }
}

