/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity.model;

import com.verdantartifice.primalmagick.common.entities.golems.AbstractEnchantedGolemEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class EnchantedGolemModel<T extends AbstractEnchantedGolemEntity>
extends HierarchicalModel<T> {
    protected final ModelPart root;
    protected final ModelPart golemHead;
    protected final ModelPart golemRightArm;
    protected final ModelPart golemLeftArm;
    protected final ModelPart golemLeftLeg;
    protected final ModelPart golemRightLeg;

    public EnchantedGolemModel(ModelPart modelPart) {
        this.root = modelPart;
        this.golemHead = modelPart.getChild("head");
        this.golemRightArm = modelPart.getChild("right_arm");
        this.golemLeftArm = modelPart.getChild("left_arm");
        this.golemRightLeg = modelPart.getChild("right_leg");
        this.golemLeftLeg = modelPart.getChild("left_leg");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.golemHead.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.golemHead.xRot = headPitch * ((float)Math.PI / 180);
        this.golemLeftLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.golemRightLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.golemLeftLeg.yRot = 0.0f;
        this.golemRightLeg.yRot = 0.0f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int timer = ((AbstractEnchantedGolemEntity)((Object)entityIn)).getAttackTimer();
        if (timer > 0) {
            this.golemRightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)timer - partialTick), (float)10.0f);
            this.golemLeftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)timer - partialTick), (float)10.0f);
        } else {
            this.golemRightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.golemLeftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }
}

