/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity.layers;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.renderers.entity.BasicPixieRenderer;
import com.verdantartifice.primalmagick.client.renderers.entity.GrandPixieRenderer;
import com.verdantartifice.primalmagick.client.renderers.entity.MajesticPixieRenderer;
import com.verdantartifice.primalmagick.client.renderers.entity.model.PixieHouseModel;
import com.verdantartifice.primalmagick.client.renderers.entity.model.PixieModel;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.common.entities.misc.PixieHouseEntity;
import com.verdantartifice.primalmagick.common.entities.pixies.PixieRank;
import com.verdantartifice.primalmagick.common.entities.pixies.companions.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.items.misc.DrainedPixieItem;
import com.verdantartifice.primalmagick.common.items.misc.IPixieItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PixieHouseOccupantLayer
extends RenderLayer<PixieHouseEntity, PixieHouseModel> {
    private static final Map<PixieRank, ResourceLocation> TEXTURES = ImmutableMap.of((Object)((Object)PixieRank.BASIC), (Object)BasicPixieRenderer.TEXTURE, (Object)((Object)PixieRank.GRAND), (Object)GrandPixieRenderer.TEXTURE, (Object)((Object)PixieRank.MAJESTIC), (Object)MajesticPixieRenderer.TEXTURE);
    private final PixieModel basePixieModel;
    private final PixieModel royalPixieModel;
    private final PixieModel baseDrainedPixieModel;
    private final PixieModel royalDrainedPixieModel;

    public PixieHouseOccupantLayer(RenderLayerParent<PixieHouseEntity, PixieHouseModel> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        this.basePixieModel = new PixieModel(pModelSet.bakeLayer(ModelLayersPM.PIXIE_BASIC));
        this.royalPixieModel = new PixieModel(pModelSet.bakeLayer(ModelLayersPM.PIXIE_ROYAL));
        this.baseDrainedPixieModel = new PixieModel(pModelSet.bakeLayer(ModelLayersPM.PIXIE_BASIC));
        this.royalDrainedPixieModel = new PixieModel(pModelSet.bakeLayer(ModelLayersPM.PIXIE_ROYAL));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, PixieHouseEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        Item item;
        ItemStack pixieStack = pLivingEntity.getHousedPixie();
        Item item2 = pixieStack.getItem();
        if (item2 instanceof IPixieItem) {
            IPixieItem pixieItem = (IPixieItem)item2;
            if (pLivingEntity.getDeployedPixieUUID().isEmpty()) {
                PixieRank pixieRank = pixieItem.getPixieRank();
                PixieModel model = pixieRank == PixieRank.MAJESTIC ? this.royalPixieModel : this.basePixieModel;
                double yBob = -0.125 * (double)Mth.sin((float)(pAgeInTicks / 6.0f));
                pPoseStack.pushPose();
                pPoseStack.translate(0.0, -0.25 + yBob, 0.0);
                pPoseStack.scale(0.25f, 0.25f, 0.25f);
                model.setupAnim((AbstractPixieEntity)null, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                VertexConsumer vertexConsumer = pBuffer.getBuffer(model.renderType(TEXTURES.get((Object)pixieRank)));
                model.renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
                pPoseStack.popPose();
                RandomSource random = pLivingEntity.getRandom();
                Source source = pixieItem.getPixieSource();
                double px = pLivingEntity.getX() + random.nextGaussian() * 0.125;
                double py = pLivingEntity.getY() + 1.5 - yBob;
                double pz = pLivingEntity.getZ() + random.nextGaussian() * 0.125;
                FxDispatcher.INSTANCE.pixieDust(px, py, pz, source.getColor());
                return;
            }
        }
        if (!((item = pixieStack.getItem()) instanceof DrainedPixieItem)) return;
        DrainedPixieItem drainedPixieItem = (DrainedPixieItem)item;
        PixieRank pixieRank = drainedPixieItem.getPixieRank();
        PixieModel model = pixieRank == PixieRank.MAJESTIC ? this.royalDrainedPixieModel : this.baseDrainedPixieModel;
        pPoseStack.pushPose();
        pPoseStack.translate(0.0, 0.27, -0.25);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        pPoseStack.scale(0.25f, 0.25f, 0.25f);
        VertexConsumer vertexConsumer = pBuffer.getBuffer(model.renderType(TEXTURES.get((Object)pixieRank)));
        model.renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
    }
}

