/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.entity.model.SpellProjectileModel;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.common.entities.projectiles.SpellProjectileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SpellProjectileRenderer
extends EntityRenderer<SpellProjectileEntity> {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/entity/spell_projectile.png");
    protected static final RenderType TRANSLUCENT_TYPE = RenderType.entityTranslucent((ResourceLocation)TEXTURE);
    protected final SpellProjectileModel model;

    public SpellProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpellProjectileModel(context.bakeLayer(ModelLayersPM.SPELL_PROJECTILE));
    }

    protected int getBlockLightLevel(SpellProjectileEntity entityIn, BlockPos blockPos) {
        return 15;
    }

    public void render(SpellProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float yaw = Mth.rotLerp((float)entity.yRotO, (float)entity.getYRot(), (float)partialTicks);
        float pitch = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float ticks = (float)entity.tickCount + partialTicks;
        int coreColor = FastColor.ARGB32.color((int)FastColor.as8BitChannel((float)1.0f), (int)entity.getColor());
        int glowColor = FastColor.ARGB32.color((int)FastColor.as8BitChannel((float)0.5f), (int)entity.getColor());
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.15, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(ticks * 0.1f)) * 180.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(ticks * 0.1f)) * 180.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(ticks * 0.15f)) * 360.0f));
        matrixStack.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, yaw, pitch);
        VertexConsumer coreVertexBuilder = buffer.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(matrixStack, coreVertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, coreColor);
        matrixStack.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer glowVertexBuilder = buffer.getBuffer(TRANSLUCENT_TYPE);
        this.model.renderToBuffer(matrixStack, glowVertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, glowColor);
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(SpellProjectileEntity entity) {
        return TEXTURE;
    }
}

