/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.common.entities.misc.SinCrystalEntity;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class SinCrystalRenderer
extends EntityRenderer<SinCrystalEntity> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_crystal/end_crystal.png");
    protected static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);
    protected static final float ANGLE = (float)Math.sin(0.7853981633974483);
    protected final ModelPart glass;
    protected final ModelPart cube;

    public SinCrystalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        ModelPart model = context.bakeLayer(ModelLayers.END_CRYSTAL);
        this.glass = model.getChild("glass");
        this.cube = model.getChild("cube");
    }

    public ResourceLocation getTextureLocation(SinCrystalEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(SinCrystalEntity livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        return super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ) || livingEntityIn.getBeamTarget() != null;
    }

    public static float getDeltaY(SinCrystalEntity entity, float partialTicks) {
        float f = (float)entity.innerRotation + partialTicks;
        float f1 = Mth.sin((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public void render(SinCrystalEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        float deltaY = SinCrystalRenderer.getDeltaY(entityIn, partialTicks);
        float f1 = ((float)entityIn.innerRotation + partialTicks) * 3.0f;
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RENDER_TYPE);
        matrixStackIn.pushPose();
        matrixStackIn.scale(2.0f, 2.0f, 2.0f);
        matrixStackIn.translate(0.0, -0.5, 0.0);
        int i = OverlayTexture.NO_OVERLAY;
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
        matrixStackIn.translate(0.0, (double)(1.5f + deltaY / 2.0f), 0.0);
        matrixStackIn.mulPose(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        this.glass.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.scale(0.875f, 0.875f, 0.875f);
        matrixStackIn.mulPose(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
        this.glass.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.scale(0.875f, 0.875f, 0.875f);
        matrixStackIn.mulPose(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
        this.cube.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
        BlockPos blockpos = entityIn.getBeamTarget();
        if (blockpos != null) {
            float targetX = (float)blockpos.getX() + 0.5f;
            float targetY = (float)blockpos.getY() + 0.5f;
            float targetZ = (float)blockpos.getZ() + 0.5f;
            float dx = (float)((double)targetX - entityIn.getX());
            float dy = (float)((double)targetY - entityIn.getY());
            float dz = (float)((double)targetZ - entityIn.getZ());
            matrixStackIn.translate((double)dx, (double)dy, (double)dz);
            EnderDragonRenderer.renderCrystalBeams((float)(-dx), (float)(-dy + deltaY), (float)(-dz), (float)partialTicks, (int)entityIn.innerRotation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

