/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.entity.layers.PixieHouseOccupantLayer;
import com.verdantartifice.primalmagick.client.renderers.entity.model.PixieHouseModel;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.common.entities.misc.PixieHouseEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PixieHouseRenderer
extends LivingEntityRenderer<PixieHouseEntity, PixieHouseModel> {
    public static final ResourceLocation DEFAULT_SKIN_LOCATION = ResourceUtils.loc("textures/entity/pixie_house.png");

    public PixieHouseRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new PixieHouseModel(pContext.bakeLayer(ModelLayersPM.PIXIE_HOUSE)), 0.0f);
        this.addLayer(new PixieHouseOccupantLayer((RenderLayerParent<PixieHouseEntity, PixieHouseModel>)this, pContext.getModelSet()));
    }

    public ResourceLocation getTextureLocation(PixieHouseEntity pixieHouseEntity) {
        return DEFAULT_SKIN_LOCATION;
    }

    protected void setupRotations(PixieHouseEntity pEntity, PoseStack pPoseStack, float pBob, float pYBodyRot, float pPartialTick, float pScale) {
        super.setupRotations((LivingEntity)pEntity, pPoseStack, pBob, pYBodyRot, pPartialTick, pScale);
        float timeSinceLastHit = (float)(pEntity.level().getGameTime() - pEntity.lastHit) + pPartialTick;
        if (timeSinceLastHit < 5.0f) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(timeSinceLastHit / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(PixieHouseEntity pEntity) {
        double distSqr = this.entityRenderDispatcher.distanceToSqr((Entity)pEntity);
        double f = pEntity.isCrouching() ? 32.0 : 64.0;
        return !(distSqr >= f * f) && pEntity.isCustomNameVisible();
    }
}

