/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.verdantartifice.primalmagick.client.renderers.entity.SinCrystalRenderer;
import com.verdantartifice.primalmagick.client.renderers.entity.layers.InnerDemonArmorLayer;
import com.verdantartifice.primalmagick.common.entities.misc.InnerDemonEntity;
import com.verdantartifice.primalmagick.common.entities.misc.SinCrystalEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class InnerDemonRenderer
extends HumanoidMobRenderer<InnerDemonEntity, PlayerModel<InnerDemonEntity>> {
    protected static final float SCALE = 2.0f;
    protected final EntityRendererProvider.Context context;
    protected InnerDemonArmorLayer armorLayer;
    protected boolean modelFinalized = false;

    public InnerDemonRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 1.0f);
        this.context = context;
        this.armorLayer = new InnerDemonArmorLayer((RenderLayerParent<InnerDemonEntity, PlayerModel<InnerDemonEntity>>)this, context.getModelSet(), false);
        this.addLayer((RenderLayer)this.armorLayer);
    }

    public ResourceLocation getTextureLocation(InnerDemonEntity entity) {
        Minecraft mc = Minecraft.getInstance();
        return mc.player.getSkin().texture();
    }

    protected void scale(InnerDemonEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        if (!this.modelFinalized) {
            Minecraft mc = Minecraft.getInstance();
            boolean slimModel = mc.player.getSkin().model().equals((Object)PlayerSkin.Model.SLIM);
            this.model = new PlayerModel(this.context.bakeLayer(slimModel ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slimModel);
            this.layers.remove((Object)this.armorLayer);
            this.armorLayer = new InnerDemonArmorLayer((RenderLayerParent<InnerDemonEntity, PlayerModel<InnerDemonEntity>>)this, this.context.getModelSet(), slimModel);
            this.addLayer((RenderLayer)this.armorLayer);
            this.modelFinalized = true;
        }
        matrixStackIn.scale(2.0f, 2.0f, 2.0f);
    }

    public void render(InnerDemonEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        for (SinCrystalEntity crystal : entityIn.getCrystalsInRange()) {
            matrixStackIn.pushPose();
            float f6 = (float)(crystal.getX() - Mth.lerp((double)partialTicks, (double)entityIn.xo, (double)entityIn.getX()));
            float f8 = (float)(crystal.getY() - Mth.lerp((double)partialTicks, (double)entityIn.yo, (double)entityIn.getY()));
            float f9 = (float)(crystal.getZ() - Mth.lerp((double)partialTicks, (double)entityIn.zo, (double)entityIn.getZ()));
            EnderDragonRenderer.renderCrystalBeams((float)f6, (float)(f8 + SinCrystalRenderer.getDeltaY(crystal, partialTicks)), (float)f9, (float)partialTicks, (int)entityIn.tickCount, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
            matrixStackIn.popPose();
        }
    }
}

