/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.verdantartifice.primalmagick.common.entities.misc.FriendlyWitchEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WitchItemLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class FriendlyWitchRenderer
extends MobRenderer<FriendlyWitchEntity, WitchModel<FriendlyWitchEntity>> {
    private static final ResourceLocation WITCH_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/witch.png");
    private static final float SCALE = 0.9375f;

    public FriendlyWitchRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WitchModel(context.bakeLayer(ModelLayers.WITCH)), 0.5f);
        this.addLayer((RenderLayer)new WitchItemLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(FriendlyWitchEntity entity) {
        return WITCH_LOCATION;
    }

    public void render(FriendlyWitchEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ((WitchModel)this.model).setHoldingItem(!entity.getMainHandItem().isEmpty());
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(FriendlyWitchEntity entity, PoseStack poseStack, float partialTicks) {
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }
}

