/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.renderers.entity.model.FlyingCarpetModel;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.common.entities.misc.FlyingCarpetEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;

public class FlyingCarpetRenderer
extends EntityRenderer<FlyingCarpetEntity> {
    private static final ResourceLocation TEXTURE_WHITE = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_white.png");
    private static final ResourceLocation TEXTURE_ORANGE = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_orange.png");
    private static final ResourceLocation TEXTURE_MAGENTA = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_magenta.png");
    private static final ResourceLocation TEXTURE_LIGHT_BLUE = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_light_blue.png");
    private static final ResourceLocation TEXTURE_YELLOW = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_yellow.png");
    private static final ResourceLocation TEXTURE_LIME = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_lime.png");
    private static final ResourceLocation TEXTURE_PINK = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_pink.png");
    private static final ResourceLocation TEXTURE_GRAY = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_gray.png");
    private static final ResourceLocation TEXTURE_LIGHT_GRAY = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_light_gray.png");
    private static final ResourceLocation TEXTURE_CYAN = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_cyan.png");
    private static final ResourceLocation TEXTURE_PURPLE = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_purple.png");
    private static final ResourceLocation TEXTURE_BLUE = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_blue.png");
    private static final ResourceLocation TEXTURE_BROWN = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_brown.png");
    private static final ResourceLocation TEXTURE_GREEN = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_green.png");
    private static final ResourceLocation TEXTURE_RED = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_red.png");
    private static final ResourceLocation TEXTURE_BLACK = ResourceUtils.loc("textures/entity/flying_carpet/flying_carpet_black.png");
    protected final FlyingCarpetModel model;

    public FlyingCarpetRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.model = new FlyingCarpetModel(context.bakeLayer(ModelLayersPM.FLYING_CARPET));
    }

    public ResourceLocation getTextureLocation(FlyingCarpetEntity entity) {
        DyeColor color = entity.getDyeColor();
        if (color == null) {
            return TEXTURE_WHITE;
        }
        switch (color) {
            default: {
                return TEXTURE_WHITE;
            }
            case ORANGE: {
                return TEXTURE_ORANGE;
            }
            case MAGENTA: {
                return TEXTURE_MAGENTA;
            }
            case LIGHT_BLUE: {
                return TEXTURE_LIGHT_BLUE;
            }
            case YELLOW: {
                return TEXTURE_YELLOW;
            }
            case LIME: {
                return TEXTURE_LIME;
            }
            case PINK: {
                return TEXTURE_PINK;
            }
            case GRAY: {
                return TEXTURE_GRAY;
            }
            case LIGHT_GRAY: {
                return TEXTURE_LIGHT_GRAY;
            }
            case CYAN: {
                return TEXTURE_CYAN;
            }
            case PURPLE: {
                return TEXTURE_PURPLE;
            }
            case BLUE: {
                return TEXTURE_BLUE;
            }
            case BROWN: {
                return TEXTURE_BROWN;
            }
            case GREEN: {
                return TEXTURE_GREEN;
            }
            case RED: {
                return TEXTURE_RED;
            }
            case BLACK: 
        }
        return TEXTURE_BLACK;
    }

    public void render(FlyingCarpetEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.375, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(this.model.renderType(this.getTextureLocation(entityIn)));
        this.model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

