/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.recipe_book;

import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.recipe_book.ClientArcaneRecipeBook;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ArcaneSearchRegistry {
    protected static final SessionSearchTrees.Key ARCANE_RECIPE_COLLECTIONS = new SessionSearchTrees.Key();
    private static CompletableFuture<SearchTree<ArcaneRecipeCollection>> recipeSearch = CompletableFuture.completedFuture(SearchTree.empty());

    private static void updateRecipes(ClientArcaneRecipeBook pArcaneRecipeBook, RegistryAccess pRegistries) {
        Minecraft.getInstance().getConnection().searchTrees().register(ARCANE_RECIPE_COLLECTIONS, () -> {
            List<ArcaneRecipeCollection> contents = pArcaneRecipeBook.getCollections();
            Registry registry = pRegistries.registryOrThrow(Registries.ITEM);
            Item.TooltipContext tooltipContext = Item.TooltipContext.of((HolderLookup.Provider)pRegistries);
            TooltipFlag.Default tooltipFlag = TooltipFlag.Default.NORMAL;
            CompletableFuture<SearchTree<ArcaneRecipeCollection>> oldFuture = recipeSearch;
            recipeSearch = CompletableFuture.supplyAsync(() -> ArcaneSearchRegistry.lambda$updateRecipes$4(pRegistries, tooltipContext, (TooltipFlag)tooltipFlag, registry, contents), Util.backgroundExecutor());
            oldFuture.cancel(true);
        });
    }

    public static SearchTree<ArcaneRecipeCollection> getSearchTree() {
        return recipeSearch.join();
    }

    private static Stream<String> getTooltipLines(Stream<ItemStack> pItems, Item.TooltipContext pContext, TooltipFlag pTooltipFlag) {
        return pItems.flatMap(stack -> stack.getTooltipLines(pContext, null, pTooltipFlag).stream()).map(component -> ChatFormatting.stripFormatting((String)component.getString()).trim()).filter(str -> !str.isEmpty());
    }

    public static void populate() {
        Minecraft mc = Minecraft.getInstance();
        ClientArcaneRecipeBook book = new ClientArcaneRecipeBook(Services.CAPABILITIES.arcaneRecipeBook((Player)mc.player).orElseThrow(() -> new IllegalArgumentException("No arcane recipe book for player")).get());
        book.setupCollections(mc.level.getRecipeManager().getRecipes(), mc.level.registryAccess());
        ArcaneSearchRegistry.updateRecipes(book, mc.level.registryAccess());
    }

    private static /* synthetic */ SearchTree lambda$updateRecipes$4(RegistryAccess pRegistries, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, Registry registry, List contents) {
        return new FullTextSearchTree(arc -> ArcaneSearchRegistry.getTooltipLines(arc.getRecipes().stream().map(recipe -> recipe.value().getResultItem((HolderLookup.Provider)pRegistries)), tooltipContext, tooltipFlag), arc -> arc.getRecipes().stream().map(recipe -> registry.getKey((Object)recipe.value().getResultItem((HolderLookup.Provider)pRegistries).getItem())), contents);
    }
}

