/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.recipe_book;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public enum ArcaneRecipeBookCategories {
    CRAFTING_SEARCH(RecipeBookCategories.CRAFTING_SEARCH, new ItemStack((ItemLike)Items.COMPASS)),
    CRAFTING_BUILDING_BLOCKS(RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, new ItemStack((ItemLike)Blocks.BRICKS)),
    CRAFTING_REDSTONE(RecipeBookCategories.CRAFTING_REDSTONE, new ItemStack((ItemLike)Items.REDSTONE)),
    CRAFTING_EQUIPMENT(RecipeBookCategories.CRAFTING_EQUIPMENT, new ItemStack((ItemLike)Items.IRON_AXE), new ItemStack((ItemLike)Items.GOLDEN_SWORD)),
    CRAFTING_MISC(RecipeBookCategories.CRAFTING_MISC, new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.APPLE)),
    CRAFTING_ARCANE(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)ItemsPM.GRIMOIRE.get())),
    CONCOCTER_SEARCH(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)Items.COMPASS)),
    CONCOCTER_DRINKABLE(RecipeBookCategories.UNKNOWN, ConcoctionUtils.newConcoction((Holder<Potion>)Potions.REGENERATION, ConcoctionType.TINCTURE)),
    CONCOCTER_BOMB(RecipeBookCategories.UNKNOWN, ConcoctionUtils.newBomb((Holder<Potion>)Potions.POISON)),
    DISSOLUTION_SEARCH(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)Items.COMPASS)),
    DISSOLUTION_ORES(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)Items.RAW_GOLD)),
    DISSOLUTION_MISC(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)Items.GRAVEL)),
    FURNACE_SEARCH(RecipeBookCategories.FURNACE_SEARCH, new ItemStack((ItemLike)Items.COMPASS)),
    FURNACE_FOOD(RecipeBookCategories.FURNACE_FOOD, new ItemStack((ItemLike)Items.PORKCHOP)),
    FURNACE_BLOCKS(RecipeBookCategories.FURNACE_BLOCKS, new ItemStack((ItemLike)Blocks.STONE)),
    FURNACE_MISC(RecipeBookCategories.FURNACE_MISC, new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.EMERALD)),
    UNKNOWN(RecipeBookCategories.UNKNOWN, new ItemStack((ItemLike)Items.BARRIER));

    public static final List<ArcaneRecipeBookCategories> CRAFTING_CATEGORIES;
    public static final List<ArcaneRecipeBookCategories> CONCOCTER_CATEGORIES;
    public static final List<ArcaneRecipeBookCategories> DISSOLUTION_CATEGORIES;
    public static final List<ArcaneRecipeBookCategories> FURNACE_CATEGORIES;
    public static final Map<ArcaneRecipeBookCategories, List<ArcaneRecipeBookCategories>> AGGREGATE_CATEGORIES;
    private final RecipeBookCategories vanillaCategory;
    private final List<ItemStack> itemIcons;

    private ArcaneRecipeBookCategories(RecipeBookCategories vanillaCategory, ItemStack ... icons) {
        this.vanillaCategory = vanillaCategory;
        this.itemIcons = ImmutableList.copyOf((Object[])icons);
    }

    @Nonnull
    public static List<ArcaneRecipeBookCategories> getCategories(ArcaneRecipeBookType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ArcaneRecipeBookType.CRAFTING -> CRAFTING_CATEGORIES;
            case ArcaneRecipeBookType.CONCOCTER -> CONCOCTER_CATEGORIES;
            case ArcaneRecipeBookType.DISSOLUTION -> DISSOLUTION_CATEGORIES;
            case ArcaneRecipeBookType.FURNACE -> FURNACE_CATEGORIES;
        };
    }

    public List<ItemStack> getIconItems() {
        return this.itemIcons;
    }

    public RecipeBookCategories getVanillaCategory() {
        return this.vanillaCategory;
    }

    static {
        CRAFTING_CATEGORIES = ImmutableList.of((Object)((Object)CRAFTING_SEARCH), (Object)((Object)CRAFTING_ARCANE), (Object)((Object)CRAFTING_EQUIPMENT), (Object)((Object)CRAFTING_BUILDING_BLOCKS), (Object)((Object)CRAFTING_MISC), (Object)((Object)CRAFTING_REDSTONE));
        CONCOCTER_CATEGORIES = ImmutableList.of((Object)((Object)CONCOCTER_SEARCH), (Object)((Object)CONCOCTER_DRINKABLE), (Object)((Object)CONCOCTER_BOMB));
        DISSOLUTION_CATEGORIES = ImmutableList.of((Object)((Object)DISSOLUTION_SEARCH), (Object)((Object)DISSOLUTION_ORES), (Object)((Object)DISSOLUTION_MISC));
        FURNACE_CATEGORIES = ImmutableList.of((Object)((Object)FURNACE_SEARCH), (Object)((Object)FURNACE_FOOD), (Object)((Object)FURNACE_BLOCKS), (Object)((Object)FURNACE_MISC));
        AGGREGATE_CATEGORIES = ImmutableMap.of((Object)((Object)CRAFTING_SEARCH), (Object)ImmutableList.of((Object)((Object)CRAFTING_ARCANE), (Object)((Object)CRAFTING_EQUIPMENT), (Object)((Object)CRAFTING_BUILDING_BLOCKS), (Object)((Object)CRAFTING_MISC), (Object)((Object)CRAFTING_REDSTONE)), (Object)((Object)CONCOCTER_SEARCH), (Object)ImmutableList.of((Object)((Object)CONCOCTER_DRINKABLE), (Object)((Object)CONCOCTER_BOMB)), (Object)((Object)DISSOLUTION_SEARCH), (Object)ImmutableList.of((Object)((Object)DISSOLUTION_ORES), (Object)((Object)DISSOLUTION_MISC)), (Object)((Object)FURNACE_SEARCH), (Object)ImmutableList.of((Object)((Object)FURNACE_FOOD), (Object)((Object)FURNACE_BLOCKS), (Object)((Object)FURNACE_MISC)));
    }
}

