/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class OtherRewardWidget
extends AbstractWidget {
    protected static final ItemStack ICON_STACK = new ItemStack((ItemLike)Items.CHEST);
    protected static final Component HEADER = Component.translatable((String)"label.primalmagick.research_table.reward.header");

    public OtherRewardWidget(List<AbstractReward<?>> rewards, int x, int y) {
        super(x, y, 16, 16, (Component)Component.empty());
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add(HEADER);
        rewards.stream().map(AbstractReward::getDescription).forEach(lines::add);
        this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines(lines)));
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.getInstance();
        double ticks = (double)mc.level.getLevelData().getGameTime() + (double)pPartialTick;
        float scale = 1.0f + 0.1f * (float)Math.sin(ticks / 2.0);
        GuiUtils.renderItemStack(pGuiGraphics, ICON_STACK, this.getX(), this.getY(), this.getMessage().getString(), true, Optional.of(new Vec3((double)scale, (double)scale, 1.0)));
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

