/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class KnowledgeTotalWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/research_table_overlay.png");
    protected static final DecimalFormat FORMATTER = new DecimalFormat("###.##");
    protected final KnowledgeType type;
    protected final Optional<IPlayerKnowledge> knowledgeOpt;
    protected final OptionalInt successDeltaOpt;
    protected Component lastTooltip = Component.empty();
    protected Component tooltip = Component.empty();

    public KnowledgeTotalWidget(int x, int y, KnowledgeType type) {
        this(x, y, type, OptionalInt.empty());
    }

    public KnowledgeTotalWidget(int x, int y, KnowledgeType type, OptionalInt successDeltaOpt) {
        super(x, y, 16, 19, (Component)Component.empty());
        Minecraft mc = Minecraft.getInstance();
        this.type = type;
        this.knowledgeOpt = Services.CAPABILITIES.knowledge((Player)mc.player);
        this.successDeltaOpt = successDeltaOpt;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.translatable((String)this.type.getNameTranslationKey()));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        guiGraphics.blit(this.type.getIconLocation(), 0, 0, 0, 0, 255, 255);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 0.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 182, 2, 16, 2);
        guiGraphics.pose().popPose();
        this.knowledgeOpt.ifPresent(knowledge -> {
            int levels = knowledge.getKnowledge(this.type);
            MutableComponent amountText = Component.literal((String)Integer.toString(levels));
            int width = mc.font.width((FormattedText)amountText);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 5.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, Color.WHITE.getRGB());
            guiGraphics.pose().popPose();
            int rawPoints = knowledge.getKnowledgeRaw(this.type);
            int levelPoints = rawPoints % this.type.getProgression();
            int px = (int)(16.0 * ((double)levelPoints / (double)this.type.getProgression()));
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 1.0f);
            guiGraphics.blit(TEXTURE, 0, 0, 182, 0, px, 2);
            guiGraphics.pose().popPose();
        });
        this.successDeltaOpt.ifPresent(points -> {
            double levels = (double)points / (double)this.type.getProgression();
            String levelStr = FORMATTER.format(Math.abs(levels));
            if (points > 0) {
                MutableComponent previewText = Component.translatable((String)"label.primalmagick.research_table.theory_gain_preview.positive", (Object[])new Object[]{levelStr}).withStyle(ChatFormatting.GREEN);
                int width = mc.font.width((FormattedText)previewText);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)this.getY(), 5.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                guiGraphics.drawString(mc.font, (Component)previewText, 0, 0, Color.WHITE.getRGB());
                guiGraphics.pose().popPose();
                if (levels == 1.0) {
                    lines.add(Component.translatable((String)"tooltip.primalmagick.research_table.theory_gain_preview.positive.single", (Object[])new Object[]{levelStr}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    lines.add(Component.translatable((String)"tooltip.primalmagick.research_table.theory_gain_preview.positive.multiple", (Object[])new Object[]{levelStr}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        });
        this.lastTooltip = this.tooltip;
        this.tooltip = CommonComponents.joinLines(lines);
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

