/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AbstractProjectMaterialWidget;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ItemTagProjectMaterial;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemTagProjectMaterialWidget
extends AbstractProjectMaterialWidget<ItemTagProjectMaterial> {
    public ItemTagProjectMaterialWidget(ItemTagProjectMaterial material, int x, int y, Set<Block> surroundings) {
        super(material, x, y, surroundings);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack toDisplay = this.getStackToDisplay();
        if (!toDisplay.isEmpty()) {
            GuiUtils.renderItemStack(guiGraphics, toDisplay, this.getX(), this.getY(), this.getMessage().getString(), false);
            if (((ItemTagProjectMaterial)this.material).getQuantity() > 1) {
                MutableComponent amountText = Component.literal((String)Integer.toString(((ItemTagProjectMaterial)this.material).getQuantity()));
                int width = mc.font.width((FormattedText)amountText);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 200.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, Color.WHITE.getRGB());
                guiGraphics.pose().popPose();
            }
        }
        super.renderWidget(guiGraphics, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
    }

    @Override
    protected List<Component> getHoverText() {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = this.getStackToDisplay();
        ArrayList<Component> textList = new ArrayList<Component>();
        MutableComponent nameComponent = stack.getHoverName().copy();
        if (nameComponent.getStyle().equals((Object)Style.EMPTY)) {
            nameComponent = nameComponent.withStyle(((Rarity)stack.getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON)).color());
        }
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            nameComponent = nameComponent.withStyle(nameComponent.getStyle().applyFormat(ChatFormatting.ITALIC));
        }
        textList.add((Component)nameComponent);
        if (!stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            stack.getItem().appendHoverText(stack, Item.TooltipContext.of((Level)mc.level), textList, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        }
        return textList;
    }

    @Nonnull
    protected ItemStack getStackToDisplay() {
        TagKey<Item> itemTag = ((ItemTagProjectMaterial)this.material).getTag();
        ArrayList tagContents = new ArrayList();
        Services.ITEMS_REGISTRY.getTag(itemTag).forEach(tagContents::add);
        if (!tagContents.isEmpty()) {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)tagContents.size());
            Item[] tagContentsArray = (Item[])tagContents.toArray(Item[]::new);
            return new ItemStack((ItemLike)tagContentsArray[index], 1);
        }
        return ItemStack.EMPTY;
    }
}

