/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AbstractProjectMaterialWidget;
import com.verdantartifice.primalmagick.common.theorycrafting.materials.ExperienceProjectMaterial;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ExperienceProjectMaterialWidget
extends AbstractProjectMaterialWidget<ExperienceProjectMaterial> {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/experience_orb.png");

    public ExperienceProjectMaterialWidget(ExperienceProjectMaterial material, int x, int y, Set<Block> surroundings) {
        super(material, x, y, surroundings);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        int textureIndex = this.getTextureIndexByXP(7 * ((ExperienceProjectMaterial)this.material).getLevels());
        int uMin = textureIndex % 4 * 16 * 4;
        int vMin = textureIndex / 4 * 16 * 4;
        double approxTicks = (double)System.currentTimeMillis() / 50.0;
        float r = (float)(Math.sin(approxTicks) + 1.0) * 0.5f;
        float g = 1.0f;
        float b = (float)(Math.sin(approxTicks + 4.188790321350098) + 1.0) * 0.1f;
        float a = 0.5f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale(0.25f, 0.25f, 0.25f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        guiGraphics.blit(EXPERIENCE_ORB_TEXTURES, 0, 0, uMin, vMin, 63, 63);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().popPose();
        if (((ExperienceProjectMaterial)this.material).getLevels() > 1) {
            MutableComponent amountText = Component.literal((String)Integer.toString(((ExperienceProjectMaterial)this.material).getLevels()));
            int width = mc.font.width((FormattedText)amountText);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 200.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, Color.WHITE.getRGB());
            guiGraphics.pose().popPose();
        }
        super.renderWidget(guiGraphics, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
    }

    protected int getTextureIndexByXP(int xpValue) {
        if (xpValue >= 2477) {
            return 10;
        }
        if (xpValue >= 1237) {
            return 9;
        }
        if (xpValue >= 617) {
            return 8;
        }
        if (xpValue >= 307) {
            return 7;
        }
        if (xpValue >= 149) {
            return 6;
        }
        if (xpValue >= 73) {
            return 5;
        }
        if (xpValue >= 37) {
            return 4;
        }
        if (xpValue >= 17) {
            return 3;
        }
        if (xpValue >= 7) {
            return 2;
        }
        return xpValue >= 3 ? 1 : 0;
    }

    @Override
    protected List<Component> getHoverText() {
        return Collections.singletonList(Component.translatable((String)"argument.entity.options.level.description"));
    }
}

