/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.common.theorycrafting.materials.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public abstract class AbstractProjectMaterialWidget<T extends AbstractProjectMaterial<T>>
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/research_table_overlay.png");
    protected final T material;
    protected final boolean complete;
    protected final boolean consumed;
    protected final boolean hasBonus;
    protected Component lastTooltip = Component.empty();
    protected Component tooltip = Component.empty();

    public AbstractProjectMaterialWidget(T material, int x, int y, Set<Block> surroundings) {
        super(x, y, 16, 16, (Component)Component.empty());
        Minecraft mc = Minecraft.getInstance();
        this.material = material;
        this.hasBonus = ((AbstractProjectMaterial)material).getBonusReward() > 0.0;
        this.consumed = ((AbstractProjectMaterial)material).isConsumed();
        this.complete = ((AbstractProjectMaterial)material).isSatisfied((Player)mc.player, this.consumed ? Collections.emptySet() : surroundings);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.complete) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 200.0f);
            guiGraphics.blit(TEXTURE, 0, 0, 162, 0, 10, 10);
            guiGraphics.pose().popPose();
        }
        if (this.consumed) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() - 3), (float)(this.getY() - 2), 200.0f);
            guiGraphics.blit(TEXTURE, 0, 0, 172, 0, 10, 10);
            guiGraphics.pose().popPose();
        }
        if (this.hasBonus) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() - 1), (float)(this.getY() + 10), 200.0f);
            guiGraphics.blit(TEXTURE, 0, 0, 215, 0, 6, 5);
            guiGraphics.pose().popPose();
        }
        this.lastTooltip = this.tooltip;
        ArrayList<Component> lines = new ArrayList<Component>(this.getHoverText());
        if (this.consumed) {
            lines.add((Component)Component.translatable((String)"tooltip.primalmagick.research_table.material.consumed").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (this.hasBonus) {
            lines.add((Component)Component.translatable((String)"tooltip.primalmagick.research_table.material.has_bonus").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        this.tooltip = CommonComponents.joinLines(lines);
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    protected abstract List<Component> getHoverText();

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

