/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.requirements.IVanillaStatRequirement;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class VanillaStatProgressWidget
extends AbstractWidget {
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected final IVanillaStatRequirement requirement;
    protected final boolean isComplete;
    protected final IconDefinition iconDef;
    protected MutableComponent lastTooltip = Component.empty();
    protected MutableComponent tooltip = Component.empty();

    public VanillaStatProgressWidget(IVanillaStatRequirement requirement, int x, int y, boolean isComplete) {
        super(x, y, 16, 18, (Component)Component.empty());
        this.requirement = requirement;
        this.isComplete = isComplete;
        this.iconDef = requirement.getIconDefinition();
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        GuiUtils.renderIconFromDefinition(pGuiGraphics, this.iconDef, this.getX(), this.getY());
        if (this.isComplete) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 100.0f);
            pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
            pGuiGraphics.pose().popPose();
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 0.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 234, 16, 2);
        pGuiGraphics.pose().popPose();
        Minecraft mc = Minecraft.getInstance();
        int currentValue = this.requirement.getCurrentValue((Player)mc.player);
        int px = (int)(16.0 * ((double)currentValue / (double)this.requirement.getThreshold()));
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 1.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 232, px, 2);
        pGuiGraphics.pose().popPose();
        this.lastTooltip = this.tooltip;
        this.tooltip = this.getDescription();
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    protected MutableComponent getDescription() {
        Minecraft mc = Minecraft.getInstance();
        Component baseDescription = this.requirement.getStatDescription();
        String currentValue = this.requirement.getStat().format(Math.min(this.requirement.getCurrentValue((Player)mc.player), this.requirement.getThreshold()));
        String maxValue = this.requirement.getStat().format(this.requirement.getThreshold());
        return Component.translatable((String)"tooltip.primalmagick.stat_progress", (Object[])new Object[]{baseDescription, currentValue, maxValue});
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

