/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractIndexIcon;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IndexIconFactory;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class UpcomingEntryWidget
extends AbstractWidget {
    protected ResearchEntry entry;
    protected AbstractIndexIcon icon;

    public UpcomingEntryWidget(int x, int y, Component text, ResearchEntry entry, boolean showIcon) {
        super(x, y, 123, 12, text);
        this.entry = entry;
        this.icon = showIcon ? IndexIconFactory.fromEntryIcon(entry.iconOpt().orElse(null), false) : null;
        Minecraft mc = Minecraft.getInstance();
        MutableComponent tooltip = Component.empty();
        if (this.entry.key().getRootKey().equals(ResearchEntries.UNKNOWN_RESEARCH)) {
            tooltip.append((Component)Component.translatable((String)"grimoire.primalmagick.unknown_upcoming"));
        } else {
            tooltip.append((Component)Component.translatable((String)"grimoire.primalmagick.upcoming_tooltip_header"));
            for (ResearchEntryKey parent : this.entry.parents()) {
                ResearchDiscipline disc;
                ResearchEntry parentEntry = ResearchEntries.getEntry(mc.level.registryAccess(), parent);
                if (parentEntry == null && !parent.isKnownBy((Player)mc.player)) {
                    tooltip.append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)("research.primalmagick." + String.valueOf(parent.getRootKey()) + ".text")));
                    continue;
                }
                if (parentEntry == null || parentEntry.key().isKnownBy((Player)mc.player)) continue;
                MutableComponent comp = Component.translatable((String)parentEntry.getNameTranslationKey());
                if (!this.entry.disciplineKeyOpt().equals(parentEntry.disciplineKeyOpt()) && parentEntry.disciplineKeyOpt().isPresent() && (disc = ResearchDisciplines.getDiscipline(mc.level.registryAccess(), parentEntry.disciplineKeyOpt().get())) != null) {
                    comp.append((Component)Component.literal((String)" ("));
                    comp.append((Component)Component.translatable((String)disc.getNameTranslationKey()));
                    comp.append((Component)Component.literal((String)")"));
                }
                tooltip.append(CommonComponents.NEW_LINE).append((Component)comp);
            }
        }
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int strWidth = mc.font.width(this.getMessage().getString());
        int dx = this.icon == null ? 0 : (this.icon.isLarge() ? 16 : 11);
        Objects.requireNonNull(mc.font);
        int dy = (this.height - 9) / 2;
        if (strWidth <= this.width - dx) {
            guiGraphics.drawString(mc.font, this.getMessage(), this.getX() + dx, this.getY() + dy, Color.GRAY.getRGB(), false);
            if (this.icon != null) {
                this.icon.render(guiGraphics, this.getX() - 2, this.getY() + dy - (this.icon.isLarge() ? 4 : 1));
            }
        } else {
            float scale = (float)(this.width - dx) / (float)strWidth;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + dx), (float)(this.getY() + dy) + 1.0f * scale, 0.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(mc.font, this.getMessage(), 0, 0, Color.GRAY.getRGB(), false);
            guiGraphics.pose().popPose();
            if (this.icon != null) {
                this.icon.render(guiGraphics, this.getX() - 2, this.getY() + dy - (this.icon.isLarge() ? 4 : 1));
            }
        }
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

