/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncResearchFlagsPacket;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.TopicLink;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.world.entity.player.Player;

public class TopicLinkButton
extends Button {
    public static final int WIDTH = 119;
    public static final int HEIGHT = 20;
    protected final AbstractResearchTopic<?> target;
    protected final GrimoireScreen screen;

    public TopicLinkButton(TopicLink link, int x, int y, GrimoireScreen screen) {
        super(x, y, 119, 20, link.getDisplayText(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
        this.target = link.target();
        this.screen = screen;
    }

    public AbstractResearchTopic<?> getTarget() {
        return this.target;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof TopicLinkButton) {
                TopicLinkButton tlb = (TopicLinkButton)button;
                AbstractResearchTopic<?> abstractResearchTopic = tlb.getTarget();
                if (abstractResearchTopic instanceof EntryResearchTopic) {
                    EntryResearchTopic ert = (EntryResearchTopic)abstractResearchTopic;
                    Minecraft mc = Minecraft.getInstance();
                    Services.CAPABILITIES.knowledge((Player)mc.player).ifPresent(knowledge -> {
                        knowledge.removeResearchFlag(ert.getEntry(), IPlayerKnowledge.ResearchFlag.NEW);
                        knowledge.removeResearchFlag(ert.getEntry(), IPlayerKnowledge.ResearchFlag.UPDATED);
                        knowledge.removeResearchFlag(ert.getEntry(), IPlayerKnowledge.ResearchFlag.HIGHLIGHT);
                        knowledge.addResearchFlag(ert.getEntry(), IPlayerKnowledge.ResearchFlag.READ);
                        PacketHandler.sendToServer(new SyncResearchFlagsPacket((Player)mc.player, ert.getEntry()));
                    });
                }
                tlb.getScreen().gotoTopic(tlb.getTarget());
            }
        }
    }
}

