/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class StatProgressWidget
extends AbstractWidget {
    protected static final ResourceLocation UNKNOWN_TEXTURE = ResourceUtils.loc("textures/research/research_unknown.png");
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected final Stat stat;
    protected final int maxValue;
    protected final int currentValue;
    protected final boolean isComplete;
    protected final ResourceLocation iconLoc;
    protected MutableComponent lastTooltip = Component.empty();
    protected MutableComponent tooltip = Component.empty();

    public StatProgressWidget(Stat stat, int maxProgressValue, int x, int y, boolean isComplete) {
        super(x, y, 16, 18, (Component)Component.empty());
        Minecraft mc = Minecraft.getInstance();
        this.stat = stat;
        this.maxValue = maxProgressValue;
        this.currentValue = StatsManager.getValue((Player)mc.player, stat);
        this.isComplete = isComplete;
        this.iconLoc = stat.iconLocationOpt().orElse(UNKNOWN_TEXTURE);
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        pGuiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        pGuiGraphics.blit(this.iconLoc, 0, 0, 0, 0, 255, 255);
        pGuiGraphics.pose().popPose();
        if (this.isComplete) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 100.0f);
            pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
            pGuiGraphics.pose().popPose();
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 0.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 234, 16, 2);
        pGuiGraphics.pose().popPose();
        int px = this.getProgressionScaled();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 1.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 232, px, 2);
        pGuiGraphics.pose().popPose();
        this.lastTooltip = this.tooltip;
        this.tooltip = Component.empty();
        this.stat.getHintTranslationKey().ifPresentOrElse(hintTranslationKey -> {
            if (Screen.hasShiftDown()) {
                this.tooltip.append((Component)Component.translatable((String)hintTranslationKey));
            } else {
                this.tooltip.append(this.getStatDescription());
                this.tooltip.append(CommonComponents.NEW_LINE);
                this.tooltip.append((Component)Component.translatable((String)"tooltip.primalmagick.more_info").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }, () -> this.tooltip.append(this.getStatDescription()));
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    protected Component getStatDescription() {
        Minecraft mc = Minecraft.getInstance();
        MutableComponent baseDescription = Component.translatable((String)this.stat.getTranslationKey());
        String currentValue = this.stat.formatter().format(Math.min(StatsManager.getValue((Player)mc.player, this.stat), this.maxValue));
        String maxValue = this.stat.formatter().format(this.maxValue);
        return Component.translatable((String)"tooltip.primalmagick.stat_progress", (Object[])new Object[]{baseDescription, currentValue, maxValue});
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }

    protected int getProgressionScaled() {
        int i = this.currentValue;
        int j = this.maxValue;
        return j != 0 && i != 0 ? (int)(16.0 * ((double)i / (double)j)) : 0;
    }
}

