/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.research.IconDefinition;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ResearchWidget
extends AbstractWidget {
    protected static final ResourceLocation UNKNOWN_TEXTURE = ResourceUtils.loc("textures/research/research_unknown.png");
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected final AbstractResearchKey<?> key;
    protected final ResearchEntry researchEntry;
    protected final boolean isComplete;
    protected MutableComponent lastTooltip = Component.empty();
    protected MutableComponent tooltip = Component.empty();

    public ResearchWidget(AbstractResearchKey<?> key, int x, int y, boolean isComplete) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.key = key;
        this.isComplete = isComplete;
        Minecraft mc = Minecraft.getInstance();
        AbstractResearchKey<?> abstractResearchKey = this.key;
        if (abstractResearchKey instanceof ResearchEntryKey) {
            ResearchEntryKey entryKey = (ResearchEntryKey)abstractResearchKey;
            this.researchEntry = ResearchEntries.getEntry(mc.level.registryAccess(), entryKey);
        } else {
            this.researchEntry = null;
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        IconDefinition iconDef = this.key.getIcon(mc.level.registryAccess());
        long time = System.currentTimeMillis();
        GuiUtils.renderIconFromDefinition(guiGraphics, iconDef, this.getX(), this.getY());
        if (this.isComplete) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 250.0f);
            guiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
            guiGraphics.pose().popPose();
        }
        this.lastTooltip = this.tooltip;
        this.tooltip = Component.empty();
        if (this.researchEntry != null) {
            this.researchEntry.getHintTranslationKey().ifPresentOrElse(hintTranslationKey -> {
                if (Screen.hasShiftDown()) {
                    this.tooltip.append((Component)Component.translatable((String)hintTranslationKey));
                } else {
                    this.tooltip.append((Component)Component.translatable((String)this.researchEntry.getNameTranslationKey()));
                    this.tooltip.append(CommonComponents.NEW_LINE);
                    this.tooltip.append((Component)Component.translatable((String)"tooltip.primalmagick.more_info").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }, () -> this.tooltip.append((Component)Component.translatable((String)this.researchEntry.getNameTranslationKey())));
        } else {
            ResearchWidget.getIconTooltip(iconDef, time).ifPresent(arg_0 -> ((MutableComponent)this.tooltip).append(arg_0));
        }
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    protected static Optional<Component> getIconTooltip(IconDefinition iconDef, long time) {
        List<Component> lines = iconDef.getTooltipLines();
        if (!lines.isEmpty()) {
            int index = (int)(time / 1000L % (long)lines.size());
            return Optional.ofNullable(lines.get(index));
        }
        return Optional.empty();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

