/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ExpertiseProgressWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemTagWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.KnowledgeWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ResearchWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.StatProgressWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.VanillaStatProgressWidget;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ExpertiseRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.IVanillaStatRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemStackRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ItemTagRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.KnowledgeRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.StatRequirement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.world.level.Level;

public class RequirementWidgetFactory {
    public static AbstractWidget fromRequirement(AbstractRequirement<?> requirement, int x, int y, boolean isComplete) {
        Minecraft mc = Minecraft.getInstance();
        if (requirement instanceof ItemStackRequirement) {
            ItemStackRequirement req = (ItemStackRequirement)requirement;
            return new ItemStackWidget(req.getStack(), x, y, isComplete);
        }
        if (requirement instanceof ItemTagRequirement) {
            ItemTagRequirement req = (ItemTagRequirement)requirement;
            return new ItemTagWidget(req.getTag(), req.getAmount(), x, y, isComplete);
        }
        if (requirement instanceof KnowledgeRequirement) {
            KnowledgeRequirement req = (KnowledgeRequirement)requirement;
            return new KnowledgeWidget(req.getKnowledgeType(), req.getAmount(), x, y, isComplete);
        }
        if (requirement instanceof ResearchRequirement) {
            ResearchRequirement req = (ResearchRequirement)requirement;
            return new ResearchWidget(req.getRootKey(), x, y, isComplete);
        }
        if (requirement instanceof ExpertiseRequirement) {
            ExpertiseRequirement req = (ExpertiseRequirement)requirement;
            return new ExpertiseProgressWidget(req.getDiscipline(), req.getTier(), req.getThreshold((Level)mc.level), x, y, isComplete);
        }
        if (requirement instanceof StatRequirement) {
            StatRequirement req = (StatRequirement)requirement;
            return new StatProgressWidget(req.getStat(), req.getRequiredValue(), x, y, isComplete);
        }
        if (requirement instanceof IVanillaStatRequirement) {
            IVanillaStatRequirement req = (IVanillaStatRequirement)((Object)requirement);
            return new VanillaStatProgressWidget(req, x, y, isComplete);
        }
        return null;
    }
}

