/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.crafting.IHasExpertise;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeExpertiseWidget
extends AbstractWidget {
    protected static final ResourceLocation ICON_LOC = ResourceUtils.loc("textures/research/expertise_expert.png");
    protected final RecipeHolder<?> recipeHolder;

    public RecipeExpertiseWidget(RecipeHolder<?> recipeHolder, int x, int y) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.recipeHolder = recipeHolder;
        this.setTooltip(Tooltip.create((Component)RecipeExpertiseWidget.makeTooltipComponent(recipeHolder)));
    }

    protected static Component makeTooltipComponent(RecipeHolder<?> recipeHolder) {
        Minecraft mc = Minecraft.getInstance();
        MutableComponent retVal = Component.empty();
        Recipe recipe = recipeHolder.value();
        if (recipe instanceof IHasExpertise) {
            IHasExpertise expRecipe = (IHasExpertise)recipe;
            expRecipe.getExpertiseGroupDescription().ifPresent(groupDesc -> {
                retVal.append((Component)Component.translatable((String)"tooltip.primalmagick.expertise.group", (Object[])new Object[]{groupDesc}));
                retVal.append(CommonComponents.NEW_LINE);
            });
            retVal.append((Component)Component.translatable((String)"tooltip.primalmagick.expertise.base", (Object[])new Object[]{expRecipe.getExpertiseReward(mc.level.registryAccess())}));
            retVal.append(CommonComponents.NEW_LINE);
            MutableComponent bonusLine = Component.translatable((String)"tooltip.primalmagick.expertise.bonus", (Object[])new Object[]{expRecipe.getBonusExpertiseReward(mc.level.registryAccess())});
            if (ExpertiseManager.isBonusEligible((Player)mc.player, recipeHolder)) {
                retVal.append((Component)bonusLine);
            } else {
                retVal.append((Component)bonusLine.withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.STRIKETHROUGH}));
                retVal.append((Component)Component.translatable((String)"tooltip.primalmagick.expertise.claimed"));
            }
        }
        return retVal;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        pGuiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        pGuiGraphics.blit(ICON_LOC, 0, 0, 0, 0, 255, 255);
        pGuiGraphics.pose().popPose();
        this.setFocused(false);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

