/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class PageButton
extends Button {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected GrimoireScreen screen;
    protected boolean isNext;

    public PageButton(int x, int y, GrimoireScreen screen, boolean isNext) {
        super(x, y, 12, 5, (Component)Component.empty(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
        this.screen = screen;
        this.isNext = isNext;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    public boolean isNext() {
        return this.isNext;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        float scaleMod = this.isHoveredOrFocused() ? Mth.sin((float)((float)mc.player.tickCount / 3.0f)) * 0.2f + 0.1f : 0.0f;
        int dx = this.width / 2;
        int dy = this.height / 2;
        guiGraphics.pose().translate((float)(this.getX() + dx), (float)(this.getY() + dy), 0.0f);
        guiGraphics.pose().scale(1.5f + scaleMod, 1.5f + scaleMod, 1.0f);
        guiGraphics.blit(TEXTURE, -dx, -dy, this.isNext ? 12 : 0, 185, this.width, this.height);
        guiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof PageButton) {
                PageButton gpb = (PageButton)button;
                if (gpb.isNext()) {
                    gpb.getScreen().nextPage();
                } else {
                    gpb.getScreen().prevPage();
                }
            }
        }
    }
}

