/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class MarkReadButton
extends Button {
    protected static final ResourceLocation SPRITE = ResourceUtils.loc("grimoire/mark_all_as_read");
    protected static final int BUTTON_WIDTH = 10;
    protected static final int BUTTON_HEIGHT = 10;
    protected static final int SPRITE_WIDTH = 16;
    protected static final int SPRITE_HEIGHT = 16;
    protected static final float BASE_SCALE = 0.625f;
    protected final Optional<ResearchDiscipline> disciplineOpt;
    protected final GrimoireScreen screen;

    public MarkReadButton(int pX, int pY, GrimoireScreen screen) {
        this(pX, pY, screen, null);
    }

    public MarkReadButton(int pX, int pY, GrimoireScreen screen, @Nullable ResearchDiscipline discipline) {
        super(pX, pY, 10, 10, (Component)Component.empty(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
        this.disciplineOpt = Optional.ofNullable(discipline);
        this.screen = screen;
        this.setTooltip(Tooltip.create((Component)((Component)this.disciplineOpt.map(d -> Component.translatable((String)"tooltip.primalmagick.mark_read.discipline", (Object[])new Object[]{Component.translatable((String)d.getNameTranslationKey())})).orElse(Component.translatable((String)"tooltip.primalmagick.mark_read.all")))));
    }

    public Optional<ResearchDiscipline> getDiscipline() {
        return this.disciplineOpt;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.getInstance();
        float scaleMod = this.isHoveredOrFocused() ? Mth.sin((float)((float)mc.player.tickCount / 3.0f)) * 0.2f + 1.1f : 1.0f;
        int dx = this.width / 2;
        int dy = this.height / 2;
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(this.getX() + dx), (float)(this.getY() + dy), 10.0f);
        pGuiGraphics.pose().scale(0.625f, 0.625f, 1.0f);
        pGuiGraphics.pose().scale(scaleMod, scaleMod, 1.0f);
        pGuiGraphics.blitSprite(SPRITE, (int)((float)(-dx) / 0.625f), (int)((float)(-dy) / 0.625f), 16, 16);
        pGuiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof MarkReadButton) {
                MarkReadButton mrb = (MarkReadButton)button;
                Minecraft mc = Minecraft.getInstance();
                mrb.getDiscipline().ifPresentOrElse(discipline -> discipline.markAllAsRead((Player)mc.player), () -> ResearchDisciplines.stream(mc.player.registryAccess()).filter(d -> d.isUnlocked((Player)mc.player)).forEach(d -> d.markAllAsRead((Player)mc.player)));
                mrb.getScreen().setRefreshing();
            }
        }
    }
}

